/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.javascript;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import org.ajax4jsf.framework.util.javascript.JSEncoder;
import org.ajax4jsf.framework.util.javascript.ScriptString;
import org.apache.commons.beanutils.PropertyUtils;

public class ScriptUtils {
    private ScriptUtils() {
    }

    public static String toScript(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof ScriptString) {
            return ((ScriptString)obj).toScript();
        }
        if (obj.getClass().isArray()) {
            StringBuffer ret = new StringBuffer("[");
            boolean first = true;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object element = Array.get(obj, i);
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element));
                first = false;
            }
            return ret.append("] ").toString();
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            StringBuffer ret = new StringBuffer("[");
            boolean first = true;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element));
                first = false;
            }
            return ret.append("] ").toString();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            StringBuffer ret = new StringBuffer("{");
            boolean first = true;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!first) {
                    ret.append(',');
                }
                ScriptUtils.addEncodedString(ret, key);
                ret.append(":");
                ret.append(ScriptUtils.toScript(map.get(key)));
                first = false;
            }
            return ret.append("} ").toString();
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof String) {
            StringBuffer ret = new StringBuffer();
            ScriptUtils.addEncodedString(ret, obj);
            return ret.toString();
        }
        try {
            StringBuffer ret = new StringBuffer("{");
            PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)obj);
            boolean first = true;
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                if (!first) {
                    ret.append(',');
                }
                ScriptUtils.addEncodedString(ret, key);
                ret.append(":");
                ret.append(ScriptUtils.toScript(PropertyUtils.getProperty((Object)obj, (String)key)));
                first = false;
            }
            return ret.append("} ").toString();
        }
        catch (Exception e) {
            throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
        }
    }

    public static void addEncodedString(StringBuffer buff, Object obj) {
        buff.append("'");
        ScriptUtils.addEncoded(buff, obj);
        buff.append("'");
    }

    public static void addEncoded(StringBuffer buff, Object obj) {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                buff.append(encoder.encode(c));
                continue;
            }
            buff.append(c);
        }
    }
}

