/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ajax4jsf.framework.resource.CountingOutputStream;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.OneTimeRenderer;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.util.javascript.JSMin;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptRenderer
extends OneTimeRenderer {
    private static final String COMPRESS_SCRIPTS_PARAMETER = "org.ajax4jsf.COMPRESS_SCRIPT";
    private static final Log _log = LogFactory.getLog((Class)ScriptRenderer.class);

    protected String getTag() {
        return "script";
    }

    protected String getHrefAttr() {
        return "src";
    }

    protected String[][] getCommonAttrs() {
        return new String[][]{{"type", this.getContentType()}};
    }

    public String getContentType() {
        return "text/javascript";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(InternetResource base, ResourceContext context) throws IOException {
        InputStream in = base.getResourceAsStream(context);
        if (null == in) {
            String message = Messages.getMessage("NO_INPUT_STREAM_ERROR", base.getKey());
            throw new IOException(message);
        }
        OutputStream out = context.getOutputStream();
        if (!"false".equalsIgnoreCase(context.getInitParameter(COMPRESS_SCRIPTS_PARAMETER))) {
            CountingOutputStream countingStream = new CountingOutputStream(out);
            JSMin jsmin = new JSMin(in, countingStream);
            try {
                jsmin.jsmin();
            }
            catch (Exception e) {
                _log.error((Object)("Error send script to client for resource " + base.getKey()), (Throwable)e);
            }
            finally {
                in.close();
                countingStream.flush();
                countingStream.close();
            }
            int written = countingStream.getWritten();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Send " + written + " bytes to client for JavaScript resource " + base.getKey()));
            }
            return written;
        }
        return this.sendStream(in, out);
    }
}

