/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.BaseResourceRenderer;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OneTimeRenderer
extends BaseResourceRenderer {
    private static final Log log = LogFactory.getLog((Class)OneTimeRenderer.class);

    public void encodeBegin(InternetResource resource, FacesContext context, Object data, Map attributes) throws IOException {
        if (!this.isRendered(resource, context)) {
            super.encodeBegin(resource, context, data, attributes);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("SKIP_ENCODE_BEGIN_HTML_INFO_2", resource.getKey()));
        }
    }

    public void encodeEnd(InternetResource resource, FacesContext context, Object data) throws IOException {
        if (!this.isRendered(resource, context)) {
            super.encodeEnd(resource, context, data);
            context.getExternalContext().getRequestMap().put(resource.getKey(), Boolean.TRUE);
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("MARK_AS_RENDERED_INFO", resource.getKey()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("SKIP_ENCODE_END_HTML_INFO_2", resource.getKey()));
        }
    }

    private boolean isRendered(InternetResource resource, FacesContext context) {
        return null != context.getExternalContext().getRequestMap().get(resource.getKey());
    }
}

