/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.ResourceBuilderImpl;
import org.ajax4jsf.framework.resource.ResourceNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InternetResourceBuilder {
    private static final Log log = LogFactory.getLog((Class)InternetResourceBuilder.class);
    private static Map instances = Collections.synchronizedMap(new HashMap());

    public abstract long getStartTime();

    public abstract InternetResource createUserResource(boolean var1, boolean var2, String var3) throws FacesException;

    public abstract void addResource(String var1, InternetResource var2);

    public abstract InternetResource getResource(String var1) throws ResourceNotFoundException;

    public abstract Object getResourceDataForKey(String var1);

    public abstract InternetResource getResourceForKey(String var1) throws ResourceNotFoundException;

    public abstract String getUri(InternetResource var1, FacesContext var2, Object var3);

    public abstract InternetResource createResource(Object var1, String var2) throws FacesException;

    public abstract void init() throws FacesException;

    public static InternetResourceBuilder getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InternetResourceBuilder instance = (InternetResourceBuilder)instances.get(loader);
        if (null == instance) {
            try {
                String resource = "META-INF/services/" + InternetResourceBuilder.class.getName();
                InputStream in = loader.getResourceAsStream(resource);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String serviceClassName = reader.readLine();
                reader.close();
                Class<?> builderClass = loader.loadClass(serviceClassName);
                instance = (InternetResourceBuilder)builderClass.newInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create instance of InternetBuilder from class " + serviceClassName));
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create default implementation instance of InternetBuilder");
                }
                instance = new ResourceBuilderImpl();
            }
            instances.put(loader, instance);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Return instance of internet resource builder " + instance.toString()));
        }
        return instance;
    }

    public static void setInstance(InternetResourceBuilder instance) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        instances.put(loader, instance);
    }
}

