/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.Path;

public class CSharp
extends MatchingTask {
    private static final String csc_exe_name = "csc";
    private static final String csc_file_ext = "cs";
    private static final String csc_file_pattern = "**/*.cs";
    private String references;
    private boolean includeDefaultReferences;
    private boolean incremental;
    private File docFile;
    private File win32icon;
    private File win32res;
    private boolean noconfig = false;
    private boolean fullpaths = false;
    private File outputFile;
    private boolean failOnError;
    private Path referenceFiles;
    private boolean optimize;
    private int fileAlign = 0;
    protected static final String DEFAULT_REFERENCE_LIST = "Accessibility.dll;cscompmgd.dll;CustomMarshalers.dll;IEExecRemote.dll;IEHost.dll;IIEHost.dll;ISymWrapper.dll;Microsoft.JScript.dll;Microsoft.VisualBasic.dll;Microsoft.VisualC.dll;Microsoft.Vsa.dll;Mscorcfg.dll;office.dll;RegCode.dll;System.Configuration.Install.dll;System.Data.dll;System.Design.dll;System.DirectoryServices.dll;System.EnterpriseServices.dll;System.dll;System.Drawing.Design.dll;System.Drawing.dll;System.Management.dll;System.Messaging.dll;System.Runtime.Remoting.dll;System.Runtime.Serialization.Formatters.Soap.dll;System.Security.dll;System.ServiceProcess.dll;System.Web.dll;System.Web.RegularExpressions.dll;System.Web.Services.dll;System.Windows.Forms.dll;System.XML.dll;";
    protected boolean debug;
    private int warnLevel;
    protected boolean unsafe;
    protected String mainClass;
    protected String extraOptions;
    private File srcDir;
    private File destDir;
    protected String targetType;
    protected boolean utf8output = false;
    String definitions;
    String additionalModules;

    public CSharp() {
        this.Clear();
        this.setIncludes(csc_file_pattern);
    }

    public void setReferences(String s) {
        this.references = s;
    }

    protected String getReferencesParameter() {
        if (this.notEmpty(this.references)) {
            return "/reference:" + this.references;
        }
        return null;
    }

    public void setReferenceFiles(Path path) {
        if (this.referenceFiles == null) {
            this.referenceFiles = new Path(this.project);
        }
        this.referenceFiles.append(path);
    }

    protected String getReferenceFilesParameter() {
        if (this.references == null) {
            return null;
        }
        String refpath = this.references.toString();
        if (refpath.length() == 0) {
            return null;
        }
        StringBuffer s = new StringBuffer("/reference:");
        s.append(refpath);
        return new String(s);
    }

    protected String getDefaultReferenceParameter() {
        if (this.includeDefaultReferences) {
            StringBuffer s = new StringBuffer("/reference:");
            s.append(DEFAULT_REFERENCE_LIST);
            return new String(s);
        }
        return null;
    }

    public void setIncludeDefaultReferences(boolean f) {
        this.includeDefaultReferences = f;
    }

    public boolean getIncludeDefaultReferences() {
        return this.includeDefaultReferences;
    }

    protected String getIncludeDefaultReferencesParameter() {
        return "/nostdlib" + (this.includeDefaultReferences ? "-" : "+");
    }

    public void setOptimize(boolean f) {
        this.optimize = f;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    protected String getOptimizeParameter() {
        return "/optimize" + (this.optimize ? "+" : "-");
    }

    public void setIncremental(boolean f) {
        this.incremental = f;
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    protected String getIncrementalParameter() {
        return "/incremental" + (this.incremental ? "+" : "-");
    }

    public void setDebug(boolean f) {
        this.debug = f;
    }

    public boolean getDebug() {
        return this.debug;
    }

    protected String getDebugParameter() {
        return "/debug" + (this.debug ? "+" : "-");
    }

    public void setDocFile(File f) {
        this.docFile = f;
    }

    protected String getDocFileParameter() {
        if (this.docFile != null) {
            return "/doc:" + this.docFile.toString();
        }
        return null;
    }

    public void setWarnLevel(int warnLevel) {
        this.warnLevel = warnLevel;
    }

    public int getWarnLevel() {
        return this.warnLevel;
    }

    protected String getWarnLevelParameter() {
        return "/warn:" + this.warnLevel;
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    public boolean getUnsafe() {
        return this.unsafe;
    }

    protected String getUnsafeParameter() {
        return this.unsafe ? "/unsafe" : null;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    protected String getMainClassParameter() {
        if (this.mainClass != null && this.mainClass.length() != 0) {
            return "/main:" + this.mainClass;
        }
        return null;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    public String getExtraOptions() {
        return this.extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this.extraOptions != null && this.extraOptions.length() != 0) {
            return this.extraOptions;
        }
        return null;
    }

    public void setSrcDir(File srcDirName) {
        this.srcDir = srcDirName;
    }

    public void setDestDir(File dirName) {
        this.destDir = dirName;
    }

    public void setTargetType(String ttype) throws BuildException {
        this.targetType = ttype.toLowerCase();
        if (!(this.targetType.equals("exe") || this.targetType.equals("library") || this.targetType.equals("module") || this.targetType.equals("winexe"))) {
            throw new BuildException("targetType " + this.targetType + " is not a valid type");
        }
        this.targetType = this.targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    protected String getTargetTypeParameter() {
        if (this.notEmpty(this.targetType)) {
            return "/target:" + this.targetType;
        }
        return null;
    }

    public void setWin32Icon(File fileName) {
        this.win32icon = fileName;
    }

    protected String getWin32IconParameter() {
        if (this.win32icon != null) {
            return "/win32icon:" + this.win32icon.toString();
        }
        return null;
    }

    public void setWin32Res(File fileName) {
        this.win32res = fileName;
    }

    protected String getWin32ResParameter() {
        if (this.win32res != null) {
            return "/win32res:" + this.win32res.toString();
        }
        return null;
    }

    public void setUtf8Output(boolean enabled) {
        this.utf8output = enabled;
    }

    protected String getUtf8OutputParameter() {
        return this.utf8output ? "/utf8output" : null;
    }

    protected void setNoConfig(boolean enabled) {
        this.noconfig = enabled;
    }

    protected String getNoConfigParameter() {
        return this.noconfig ? "/noconfig" : null;
    }

    public void setFullPaths(boolean enabled) {
        this.fullpaths = enabled;
    }

    protected String getFullPathsParameter() {
        return this.fullpaths ? "/fullpaths" : null;
    }

    public void setDefinitions(String params) {
        this.definitions = params;
    }

    protected String getDefinitionsParameter() {
        if (this.notEmpty(this.definitions)) {
            return "/define:" + this.definitions;
        }
        return null;
    }

    public void setAdditionalModules(String params) {
        this.additionalModules = params;
    }

    protected String getAdditionalModulesParameter() {
        if (this.notEmpty(this.additionalModules)) {
            return "/addmodule:" + this.additionalModules;
        }
        return null;
    }

    public void setOutputFile(File params) {
        this.outputFile = params;
    }

    public void setDestFile(File file) {
        this.outputFile = file;
    }

    protected String getOutputFileParameter() {
        if (this.outputFile != null) {
            File f = this.outputFile;
            return "/out:" + f.toString();
        }
        return null;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFileAlign(int fileAlign) {
        this.fileAlign = fileAlign;
    }

    protected String getFileAlignParameter() {
        if (this.fileAlign != 0) {
            return "/filealign:" + this.fileAlign;
        }
        return null;
    }

    public void Clear() {
        this.targetType = null;
        this.win32icon = null;
        this.srcDir = null;
        this.destDir = null;
        this.mainClass = null;
        this.unsafe = false;
        this.warnLevel = 3;
        this.docFile = null;
        this.incremental = false;
        this.optimize = false;
        this.debug = true;
        this.references = null;
        this.failOnError = true;
        this.definitions = null;
        this.additionalModules = null;
        this.includeDefaultReferences = true;
        this.extraOptions = null;
        this.fullpaths = true;
        this.fileAlign = 0;
    }

    protected boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    protected void validate() throws BuildException {
        if (this.outputFile != null && this.outputFile.isDirectory()) {
            throw new BuildException("destFile cannot be a directory");
        }
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            this.srcDir = this.project.resolveFile(".");
        }
        this.log("CSC working from source directory " + this.srcDir, 3);
        this.validate();
        NetCommand command = new NetCommand((Task)this, "CSC", csc_exe_name);
        command.setFailOnError(this.getFailOnError());
        command.setTraceCommandLine(true);
        command.addArgument("/nologo");
        command.addArgument(this.getAdditionalModulesParameter());
        command.addArgument(this.getDefinitionsParameter());
        command.addArgument(this.getDebugParameter());
        command.addArgument(this.getDocFileParameter());
        command.addArgument(this.getIncrementalParameter());
        command.addArgument(this.getMainClassParameter());
        command.addArgument(this.getOptimizeParameter());
        command.addArgument(this.getReferencesParameter());
        command.addArgument(this.getTargetTypeParameter());
        command.addArgument(this.getUnsafeParameter());
        command.addArgument(this.getWarnLevelParameter());
        command.addArgument(this.getWin32IconParameter());
        command.addArgument(this.getOutputFileParameter());
        command.addArgument(this.getIncludeDefaultReferencesParameter());
        command.addArgument(this.getDefaultReferenceParameter());
        command.addArgument(this.getWin32ResParameter());
        command.addArgument(this.getUtf8OutputParameter());
        command.addArgument(this.getNoConfigParameter());
        command.addArgument(this.getFullPathsParameter());
        command.addArgument(this.getExtraOptionsParameter());
        command.addArgument(this.getFileAlignParameter());
        long outputTimestamp = this.outputFile != null && this.outputFile.exists() ? this.outputFile.lastModified() : 0L;
        int filesOutOfDate = 0;
        DirectoryScanner scanner = super.getDirectoryScanner(this.srcDir);
        String[] dependencies = scanner.getIncludedFiles();
        this.log("compiling " + dependencies.length + " file" + (dependencies.length == 1 ? "" : "s"));
        String baseDir = scanner.getBasedir().toString();
        File base = scanner.getBasedir();
        int i = 0;
        while (i < dependencies.length) {
            File targetFile = new File(base, dependencies[i]);
            this.log(targetFile.toString(), 3);
            command.addArgument(targetFile.toString());
            if (targetFile.lastModified() > outputTimestamp) {
                ++filesOutOfDate;
                this.log("Source file " + targetFile.toString() + " is out of date", 3);
            } else {
                this.log("Source file " + targetFile.toString() + " is up to date", 3);
            }
            ++i;
        }
        if (filesOutOfDate > 0) {
            command.runCommand();
        }
    }

    static {
        csc_exe_name = csc_exe_name;
        csc_file_ext = csc_file_ext;
        csc_file_pattern = csc_file_pattern;
        DEFAULT_REFERENCE_LIST = DEFAULT_REFERENCE_LIST;
    }
}

