/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine.buffer;

import com.octo.captcha.Captcha;
import com.octo.captcha.engine.bufferedengine.buffer.CaptchaBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryCaptchaBuffer
implements CaptchaBuffer {
    private static final Log log = LogFactory.getLog(MemoryCaptchaBuffer.class);
    protected HashedMap buffers = new HashedMap();

    public MemoryCaptchaBuffer() {
        log.info((Object)"Initializing Buffer");
        log.info((Object)("Buffer size : " + this.size()));
        log.info((Object)"Buffer initialized");
    }

    public Captcha removeCaptcha(Locale locale) throws NoSuchElementException {
        Captcha captcha = null;
        if (this.buffers.containsKey((Object)locale)) {
            try {
                captcha = (Captcha)((UnboundedFifoBuffer)this.buffers.get((Object)locale)).remove();
                log.debug((Object)"get captcha from MemoryBuffer");
            }
            catch (NoSuchElementException e) {
                log.debug((Object)("Buffer empty for locale : " + locale.toString()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Locale not present : " + locale.toString()));
        }
        return captcha;
    }

    public Collection removeCaptcha(int number, Locale locale) {
        ArrayList<Object> list = new ArrayList<Object>(number);
        UnboundedFifoBuffer buffer = (UnboundedFifoBuffer)this.buffers.get((Object)locale);
        if (buffer == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Locale not found in Memory buffer map : " + locale.toString()));
            }
            return list;
        }
        try {
            for (int i = 0; i < number; ++i) {
                list.add(buffer.remove());
            }
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("Buffer empty for locale : " + locale.toString()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed from locale :'" + locale + "' a list of '" + list.size() + "' elements."));
        }
        return list;
    }

    public Collection removeCaptcha(int number) {
        return this.removeCaptcha(number, Locale.getDefault());
    }

    public Captcha removeCaptcha() throws NoSuchElementException {
        return this.removeCaptcha(Locale.getDefault());
    }

    public void putCaptcha(Captcha captcha, Locale locale) {
        if (!this.buffers.containsKey((Object)locale)) {
            this.buffers.put((Object)locale, (Object)new UnboundedFifoBuffer());
        }
        ((UnboundedFifoBuffer)this.buffers.get((Object)locale)).add((Object)captcha);
    }

    public void putAllCaptcha(Collection captchas, Locale locale) {
        if (!this.buffers.containsKey((Object)locale)) {
            this.buffers.put((Object)locale, (Object)new UnboundedFifoBuffer());
        }
        ((UnboundedFifoBuffer)this.buffers.get((Object)locale)).addAll(captchas);
        if (log.isDebugEnabled()) {
            log.debug((Object)("put into mem  : " + captchas.size() + " for locale :" + locale.toString() + " with size : " + ((UnboundedFifoBuffer)this.buffers.get((Object)locale)).size()));
        }
    }

    public int size() {
        int total = 0;
        Iterator it = this.buffers.keySet().iterator();
        while (it.hasNext()) {
            total += ((UnboundedFifoBuffer)this.buffers.get(it.next())).size();
        }
        return total;
    }

    public int size(Locale locale) {
        if (!this.buffers.containsKey((Object)locale)) {
            this.buffers.put((Object)locale, (Object)new UnboundedFifoBuffer());
        }
        return ((UnboundedFifoBuffer)this.buffers.get((Object)locale)).size();
    }

    public void putCaptcha(Captcha captcha) {
        this.putCaptcha(captcha, Locale.getDefault());
    }

    public void putAllCaptcha(Collection captchas) {
        this.putAllCaptcha(captchas, Locale.getDefault());
    }

    public void dispose() {
    }

    public void clear() {
        this.buffers.clear();
    }

    public Collection getLocales() {
        return this.buffers.keySet();
    }
}

