/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.fontgenerator;

import com.octo.captcha.component.image.fontgenerator.AbstractFontGenerator;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class RandomFontGenerator
extends AbstractFontGenerator {
    private int[] STYLES = new int[]{0, 2, 1, 3};
    private String requiredCharacters = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static String[] defaultBadFontNamePrefixes = new String[]{"Courier", "Times Roman"};
    private String[] badFontNamePrefixes = defaultBadFontNamePrefixes;
    private static final int GENERATED_FONTS_ARRAY_SIZE = 3000;
    private Font[] generatedFonts = new Font[3000];
    private List fonts = null;
    protected Random myRandom = new SecureRandom();

    public RandomFontGenerator(Integer minFontSize, Integer maxFontSize) {
        super(minFontSize, maxFontSize);
        this.fonts = this.initializeFonts(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts());
        if (this.fonts.size() < 1) {
            throw new IllegalArgumentException("fonts list cannot be null or empty, some of your font are removed from the list by this class, Courrier and TimesRoman");
        }
        this.generatedFonts = this.generateFontArray();
    }

    public RandomFontGenerator(Integer minFontSize, Integer maxFontSize, Font[] fontsList) {
        super(minFontSize, maxFontSize);
        if (fontsList == null || fontsList.length < 1) {
            throw new IllegalArgumentException("fonts list cannot be null or empty");
        }
        this.fonts = this.initializeFonts(fontsList);
        if (this.fonts.size() < 1) {
            throw new IllegalArgumentException("fonts list cannot be null or empty, some of your font are removed from the list by this class, Courrier and TimesRoman");
        }
        this.generatedFonts = this.generateFontArray();
    }

    public Font getFont() {
        return this.generatedFonts[Math.abs(this.myRandom.nextInt(3000))];
    }

    private Font[] generateFontArray() {
        Font[] generatedFonts = new Font[3000];
        for (int i = 0; i < 3000; ++i) {
            Font font = (Font)this.fonts.get(this.myRandom.nextInt(this.fonts.size()));
            int plus = 0;
            if (this.getMaxFontSize() - this.getMinFontSize() > 0) {
                plus = Math.abs(this.myRandom.nextInt(this.getMaxFontSize() - this.getMinFontSize()));
            }
            Font styled = new Font(font.getFontName(), this.STYLES[this.myRandom.nextInt(this.STYLES.length)], this.getMinFontSize() + plus);
            generatedFonts[i] = this.applyCustomDeformationOnGeneratedFont(styled);
        }
        return generatedFonts;
    }

    protected Font applyCustomDeformationOnGeneratedFont(Font font) {
        return font;
    }

    private List initializeFonts(Font[] uncheckFonts) {
        ArrayList<Font> goodFonts = new ArrayList<Font>(uncheckFonts.length);
        goodFonts.addAll(Arrays.asList(uncheckFonts));
        Iterator iter = goodFonts.iterator();
        block0: while (iter.hasNext()) {
            int i;
            Font f = (Font)iter.next();
            boolean removed = false;
            for (i = 0; i < this.requiredCharacters.length(); ++i) {
                if (f.canDisplay(this.requiredCharacters.charAt(i))) continue;
                iter.remove();
                removed = true;
                break;
            }
            if (removed) continue;
            for (i = 0; i < this.badFontNamePrefixes.length; ++i) {
                if (!f.getName().startsWith(this.badFontNamePrefixes[i])) continue;
                iter.remove();
                continue block0;
            }
        }
        return goodFonts;
    }

    public String getRequiredCharacters() {
        return this.requiredCharacters;
    }

    public void setRequiredCharacters(String requiredCharacters) {
        this.requiredCharacters = requiredCharacters;
    }

    public String[] getBadFontNamePrefixes() {
        return this.badFontNamePrefixes;
    }

    public void setBadFontNamePrefixes(String[] badFontNamePrefixes) {
        this.badFontNamePrefixes = badFontNamePrefixes;
    }
}

