/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.graph.exe.ProcessInstance;

public class GetProcessInstancesCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -5601050489405283851L;
    private static final Log log = LogFactory.getLog((Class)GetProcessInstancesCommand.class);
    private boolean onlyRunning = true;
    private Date fromStartDate;
    private Date untilStartDate;
    private String processName;
    private String stateName;
    private transient boolean firstExpression = true;

    private String getConcatExpression() {
        if (this.firstExpression) {
            this.firstExpression = false;
            return " where ";
        }
        return " and ";
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.firstExpression = true;
        StringBuffer queryText = new StringBuffer("select pi from org.jbpm.graph.exe.ProcessInstance as pi ");
        if (this.onlyRunning) {
            queryText.append(this.getConcatExpression()).append(" pi.end = null");
        }
        if (this.fromStartDate != null) {
            queryText.append(this.getConcatExpression()).append(" pi.start >= :from ");
        }
        if (this.untilStartDate != null) {
            queryText.append(this.getConcatExpression()).append(" pi.start <= :until ");
        }
        if (this.processName != null && this.processName.length() > 0) {
            queryText.append(this.getConcatExpression()).append(" pi.processDefinition.name = :processDefinitionName  ");
        }
        if (this.stateName != null && this.stateName.length() > 0) {
            queryText.append(this.getConcatExpression()).append(" pi.rootToken.node.name = :nodeName ");
        }
        queryText.append(" order by pi.start desc");
        Query query = jbpmContext.getSession().createQuery(queryText.toString());
        if (this.fromStartDate != null) {
            query.setDate("from", this.fromStartDate);
        }
        if (this.untilStartDate != null) {
            query.setDate("until", this.untilStartDate);
        }
        if (this.processName != null && this.processName.length() > 0) {
            query.setString("processDefinitionName", this.processName);
        }
        if (this.stateName != null && this.stateName.length() > 0) {
            query.setString("nodeName", this.stateName);
        }
        return this.retrieveProcessInstanceDetails(query.list());
    }

    public List retrieveProcessInstanceDetails(List processInstanceList) {
        Iterator it = processInstanceList.iterator();
        while (it.hasNext()) {
            this.retrieveProcessInstance((ProcessInstance)it.next());
        }
        return processInstanceList;
    }

    public Date getFromStartDate() {
        return this.fromStartDate;
    }

    public void setFromStartDate(Date fromStartDate) {
        this.fromStartDate = fromStartDate;
    }

    public boolean isOnlyRunning() {
        return this.onlyRunning;
    }

    public void setOnlyRunning(boolean onlyRunning) {
        this.onlyRunning = onlyRunning;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Date getUntilStartDate() {
        return this.untilStartDate;
    }

    public void setUntilStartDate(Date untilStartDate) {
        this.untilStartDate = untilStartDate;
    }
}

