/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class AbstractCancelCommand {
    protected transient JbpmContext jbpmContext = null;
    protected static final Log log = LogFactory.getLog((Class)AbstractCancelCommand.class);

    protected void cancelTokens(Collection tokens) {
        log.info((Object)("cancel " + tokens.size() + " tokens"));
        if (tokens != null && tokens.size() > 0) {
            Iterator itr = tokens.iterator();
            while (itr.hasNext()) {
                this.cancelToken((Token)itr.next());
            }
        }
    }

    protected void cancelToken(Token token) {
        token.end(false);
        this.cancelTasks(this.getTasksForToken(token));
        log.info((Object)("token " + token + " canceled"));
    }

    protected List getTasksForToken(Token token) {
        Query hqlQuery = this.jbpmContext.getSession().getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
        hqlQuery.setLong("tokenId", token.getId());
        return hqlQuery.list();
    }

    protected void cancelTasks(List tasks) {
        log.info((Object)("cancel " + tasks.size() + " tasks"));
        if (tasks != null && tasks.size() > 0) {
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                TaskInstance ti = (TaskInstance)it.next();
                log.info((Object)("cancel task " + ti));
                ti.setSignalling(false);
                ti.cancel();
            }
        }
    }
}

