/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.MethodHashing;

public class ClassProxyContainer
extends ClassContainer {
    public ClassProxyContainer(String name, AspectManager manager) {
        super(name, manager);
    }

    protected void createConstructorTables() {
        this.constructors = this.clazz.getSuperclass().getDeclaredConstructors();
        for (int i = 0; i < this.constructors.length; ++i) {
            this.constructors[i].setAccessible(true);
        }
        Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
    }

    protected void createMethodMap() {
        try {
            Method[] declaredMethods = this.clazz.getMethods();
            Class superclass = this.clazz.getSuperclass();
            for (int i = 0; i < declaredMethods.length; ++i) {
                Method method = declaredMethods[i];
                if (!ClassAdvisor.isAdvisable(method)) continue;
                long hash = MethodHashing.methodHash(method);
                try {
                    method = superclass.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException ignored) {
                    // empty catch block
                }
                this.advisedMethods.put(hash, (Object)method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

