/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResult
implements ITestResult {
    private IClass m_testClass = null;
    private ITestNGMethod m_method = null;
    private int m_status = -1;
    private Throwable m_throwable = null;
    private long m_startMillis = 0L;
    private long m_endMillis = 0L;
    private String m_name = null;
    private List<String> m_output;
    private String m_host;

    public TestResult(IClass testClass, ITestNGMethod method, Throwable throwable, long start, long end, List<String> output) {
        this.m_testClass = testClass;
        this.m_throwable = throwable;
        this.m_output = output;
        if (null == this.m_throwable) {
            this.m_status = 1;
        }
        this.m_startMillis = start;
        this.m_endMillis = end;
        this.m_method = method;
        this.m_name = this.m_method.getMethod().getName();
    }

    private static void ppp(String s) {
        System.out.println("[TestResult] " + s);
    }

    @Override
    public void setEndMillis(long millis) {
        this.m_endMillis = millis;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(ITestNGMethod method) {
        this.m_method = method;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public boolean isSuccess() {
        return 1 == this.m_status;
    }

    @Override
    public IClass getTestClass() {
        return this.m_testClass;
    }

    public void setTestClass(IClass testClass) {
        this.m_testClass = testClass;
    }

    @Override
    public Throwable getThrowable() {
        return this.m_throwable;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    @Override
    public long getEndMillis() {
        return this.m_endMillis;
    }

    @Override
    public long getStartMillis() {
        return this.m_startMillis;
    }

    @Override
    public List<String> getOutput() {
        return this.m_output;
    }

    public String toString() {
        return "[TestResult: " + this.getName() + " STATUS:" + this.m_status + " METHOD:" + this.m_method + this.getOutput() != null && this.getOutput().size() > 0 ? this.getOutput().get(0) : "]";
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }
}

