/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.ArrayIterator;
import org.testng.internal.Graph;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.ITestOrConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHelper {
    private static boolean m_quiet = true;

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder) {
        return MethodHelper.collectAndOrderMethods(methods.toArray(new ITestNGMethod[methods.size()]), forTests, runInfo, finder, false);
    }

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        return MethodHelper.collectAndOrderMethods(methods.toArray(new ITestNGMethod[methods.size()]), forTests, runInfo, finder, unique);
    }

    public static ITestNGMethod[] collectAndOrderMethods(ITestNGMethod[] methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder) {
        return MethodHelper.collectAndOrderMethods(methods, forTests, runInfo, finder, false);
    }

    public static ITestNGMethod[] collectAndOrderMethods(ITestNGMethod[] methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        ArrayList<ITestNGMethod> allMethods = new ArrayList<ITestNGMethod>();
        MethodHelper.collectMethodsByGroup(methods, forTests, allMethods, runInfo, finder, unique);
        List<ITestNGMethod> vResult = MethodHelper.sortMethods(forTests, allMethods, finder);
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static ITestNGMethod[] collectAndOrderConfigurationMethods(ITestNGMethod[] methods, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        return MethodHelper.collectAndOrderMethods(methods, false, runInfo, finder, unique);
    }

    public static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, ITestNGMethod[] methods, String groupRegexp) {
        boolean foundGroup = false;
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            String[] groups;
            for (String group : groups = tm.getGroups()) {
                if (!Pattern.matches(groupRegexp, group)) continue;
                vResult.add(tm);
                foundGroup = true;
            }
        }
        if (!foundGroup) {
            method.setMissingGroup(groupRegexp);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static ITestNGMethod[] findMethodsNamed(String mainMethod, ITestNGMethod[] methods, String[] regexps) {
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        String currentRegexp = null;
        String[] arr$ = regexps;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String fullyQualifiedRegexp;
            String regexp = fullyQualifiedRegexp = arr$[i$];
            boolean foundAtLeastAMethod = false;
            if (regexp != null) {
                currentRegexp = regexp;
                boolean usePackage = regexp.indexOf(".") != -1;
                for (ITestNGMethod method : methods) {
                    String methodName;
                    Method thisMethod = method.getMethod();
                    String thisMethodName = thisMethod.getName();
                    String string = methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(thisMethod) : thisMethodName;
                    if (!Pattern.matches(regexp, methodName)) continue;
                    vResult.add(method);
                    foundAtLeastAMethod = true;
                }
            }
            if (foundAtLeastAMethod) continue;
            throw new TestNGException(mainMethod + "() is depending on nonexistent method " + currentRegexp);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    public static boolean isEnabled(Class objectClass, IAnnotationFinder finder) {
        ITest testClassAnnotation = AnnotationHelper.findTest(finder, objectClass);
        return MethodHelper.isEnabled(testClassAnnotation);
    }

    public static boolean isEnabled(Method m, IAnnotationFinder finder) {
        ITest annotation = AnnotationHelper.findTest(finder, m);
        if (null == annotation) {
            annotation = AnnotationHelper.findTest(finder, m.getDeclaringClass());
        }
        return MethodHelper.isEnabled(annotation);
    }

    public static boolean isEnabled(ITestOrConfiguration test) {
        return null == test || null != test && test.getEnabled();
    }

    public static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, List<ITestNGMethod> methods, String groupRegexp) {
        ITestNGMethod[] allMethods = methods.toArray(new ITestNGMethod[methods.size()]);
        return MethodHelper.findMethodsThatBelongToGroup(method, allMethods, groupRegexp);
    }

    public static void findGroupTransitiveClosure(XmlMethodSelector xms, ITestNGMethod[] methods, String[] includedGroups, List<String> outGroups, List<String> outMethods) {
        boolean hasDependents = false;
        xms.setVerbose(false);
        for (ITestNGMethod m : methods) {
            if (!xms.includeMethod(m, true) || m.getMethodsDependedUpon().length <= 0 && m.getGroupsDependedUpon().length <= 0) continue;
            hasDependents = true;
            break;
        }
        xms.setVerbose(true);
        if (hasDependents) {
            MethodHelper.privateFindGroupTransitiveClosure(methods, includedGroups, outGroups, outMethods);
        } else {
            outGroups.addAll(Arrays.asList(includedGroups));
            for (ITestNGMethod m : methods) {
                if (!xms.includeMethod(m, true)) continue;
                outMethods.add(m.getMethod().getName());
            }
        }
    }

    private static void privateFindGroupTransitiveClosure(ITestNGMethod[] methods, String[] includedGroups, List<String> outGroups, List<String> outMethods) {
        boolean keepGoing = false;
        HashMap<String, String> vGroupResult = new HashMap<String, String>();
        HashMap<String, String> vMethodResult = new HashMap<String, String>();
        for (String g : includedGroups) {
            vGroupResult.put(g, g);
        }
        do {
            keepGoing = false;
            HashMap<String, String> moreGroups = new HashMap<String, String>();
            HashMap<String, String> moreMethods = new HashMap<String, String>();
            for (String group : vGroupResult.keySet()) {
                vGroupResult.put(group, group);
                for (ITestNGMethod m : methods) {
                    String[] methodsDependedUpon;
                    String[] groupsDependedUpon;
                    for (String gdu : groupsDependedUpon = m.getGroupsDependedUpon()) {
                        if (vGroupResult.containsKey(gdu)) continue;
                        moreGroups.put(gdu, gdu);
                        keepGoing = true;
                    }
                    for (String gdu : methodsDependedUpon = m.getMethodsDependedUpon()) {
                        if (vMethodResult.containsKey(gdu)) continue;
                        moreMethods.put(gdu, gdu);
                        keepGoing = true;
                    }
                }
            }
            for (String g : moreGroups.keySet()) {
                vGroupResult.put(g, g);
            }
            for (String g : moreMethods.keySet()) {
                vMethodResult.put(g, g);
            }
        } while (keepGoing);
        outGroups.addAll(vGroupResult.values());
        outMethods.addAll(vMethodResult.values());
    }

    private static void collectMethodsByGroup(ITestNGMethod[] methods, boolean forTests, List<ITestNGMethod> vResult, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        for (ITestNGMethod tm : methods) {
            ITestOrConfiguration annotation;
            Method m = tm.getMethod();
            if (forTests) {
                annotation = AnnotationHelper.findTest(finder, m);
                if (!MethodHelper.isEnabled(annotation) || !runInfo.includeMethod(tm, forTests)) continue;
                if (unique) {
                    if (MethodHelper.isMethodAlreadyPresent(vResult, tm)) continue;
                    vResult.add(tm);
                    continue;
                }
                vResult.add(tm);
                continue;
            }
            annotation = AnnotationHelper.findConfiguration(finder, m);
            if (!MethodHelper.isEnabled(annotation) || !runInfo.includeMethod(tm, forTests)) continue;
            if (unique) {
                if (MethodHelper.isMethodAlreadyPresent(vResult, tm)) continue;
                vResult.add(tm);
                continue;
            }
            vResult.add(tm);
        }
    }

    private static boolean isMethodAlreadyPresent(List<ITestNGMethod> result, ITestNGMethod tm) {
        for (ITestNGMethod m : result) {
            Class<?> c2;
            Class<?> c1;
            Method jm1 = m.getMethod();
            Method jm2 = tm.getMethod();
            if (!jm1.getName().equals(jm2.getName()) || !(c1 = jm1.getDeclaringClass()).isAssignableFrom(c2 = jm2.getDeclaringClass()) && !c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static Graph topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        Graph<ITestNGMethod> result = new Graph<ITestNGMethod>();
        for (ITestNGMethod m : methods) {
            result.addNode(m);
            HashMap<ITestNGMethod, ITestNGMethod> predecessors = new HashMap<ITestNGMethod, ITestNGMethod>();
            String[] methodsDependedUpon = m.getMethodsDependedUpon();
            String[] groupsDependedUpon = m.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                String methodName = MethodHelper.calculateMethodCanonicalName(m);
                for (ITestNGMethod pred : methodsNamed = MethodHelper.findMethodsNamed(methodName, methods, methodsDependedUpon)) {
                    predecessors.put(pred, pred);
                }
            }
            if (groupsDependedUpon.length > 0) {
                for (String group : groupsDependedUpon) {
                    ITestNGMethod[] methodsThatBelongToGroup;
                    for (ITestNGMethod pred : methodsThatBelongToGroup = MethodHelper.findMethodsThatBelongToGroup(m, methods, group)) {
                        predecessors.put(pred, pred);
                    }
                }
            }
            for (ITestNGMethod predecessor : predecessors.values()) {
                result.addPredecessor(m, predecessor);
            }
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    public static String calculateMethodCanonicalName(ITestNGMethod m) {
        return MethodHelper.calculateMethodCanonicalName(m.getMethod());
    }

    public static String calculateMethodCanonicalName(Method m) {
        String packageName = m.getDeclaringClass().getName() + "." + m.getName();
        for (Class<?> cls = m.getDeclaringClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                if (cls.getDeclaredMethod(m.getName(), m.getParameterTypes()) == null) continue;
                packageName = cls.getName();
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String result = packageName + "." + m.getName();
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, IAnnotationFinder finder) {
        ArrayList<ITestNGMethod> sl = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> pl = new ArrayList<ITestNGMethod>();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[allMethods.size()]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m = allMethodsArray[0];
            boolean before = m.isBeforeClassConfiguration() || m.isBeforeMethodConfiguration() || m.isBeforeSuiteConfiguration() || m.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(allMethodsArray, before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl);
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        result.addAll(pl);
        result.addAll(sl);
        return result;
    }

    private static void log(int level, String s) {
        if (level <= TestRunner.getVerbose()) {
            MethodHelper.ppp(s);
        }
    }

    public static void ppp(String s) {
        System.out.println("[MethodHelper] " + s);
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods) {
        ArrayList<ITestNGMethod> parallelList = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> sequentialList = new ArrayList<ITestNGMethod>();
        Graph g = MethodHelper.topologicalSort(methods, sequentialList, parallelList);
        List<ITestNGMethod> result = g.findPredecessors(method);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeMethod(Method thisMethod, Object instance, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        Object result = null;
        boolean isPublic = Modifier.isPublic(thisMethod.getModifiers());
        try {
            if (!isPublic) {
                thisMethod.setAccessible(true);
            }
            result = thisMethod.invoke(instance, parameters);
        }
        finally {
            if (!isPublic) {
                thisMethod.setAccessible(false);
            }
        }
        return result;
    }

    public static Iterator<Object[]> createArrayIterator(Object[][] objects) {
        return new ArrayIterator(objects);
    }

    public static Iterator<Object[]> invokeDataProvider(Object instance, Method dataProvider) {
        Iterator result;
        block5: {
            result = null;
            try {
                Class<?> returnType = dataProvider.getReturnType();
                if (Object[][].class.isAssignableFrom(returnType)) {
                    Object[][] oResult = (Object[][])MethodHelper.invokeMethod(dataProvider, instance, null);
                    result = MethodHelper.createArrayIterator(oResult);
                    break block5;
                }
                if (Iterator.class.isAssignableFrom(returnType)) {
                    result = (Iterator)MethodHelper.invokeMethod(dataProvider, instance, null);
                    break block5;
                }
                throw new TestNGException("Data Provider " + dataProvider + " must return" + " either Object[][] or Iterator<Object>[], not " + returnType);
            }
            catch (InvocationTargetException e) {
                throw new TestNGException(e);
            }
            catch (IllegalAccessException e) {
                throw new TestNGException(e);
            }
        }
        return result;
    }

    public static String calculateMethodCanonicalName(Class methodClass, String methodName) {
        Method[] methods = methodClass.getMethods();
        Method result = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            result = m;
            break;
        }
        return result != null ? MethodHelper.calculateMethodCanonicalName(result) : null;
    }
}

