/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class GraphSession {
    JbpmSession jbpmSession = null;
    Session session = null;
    private static final Log log = LogFactory.getLog((Class)GraphSession.class);

    public GraphSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public GraphSession(Session session) {
        this.session = session;
        this.jbpmSession = new JbpmSession(session);
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        String processDefinitionName = processDefinition.getName();
        if (processDefinitionName != null) {
            ProcessDefinition previousLatestVersion = this.findLatestProcessDefinition(processDefinitionName);
            if (previousLatestVersion != null) {
                processDefinition.setVersion(previousLatestVersion.getVersion() + 1);
            } else {
                processDefinition.setVersion(1);
            }
        } else {
            throw new JbpmException("process definition does not have a name");
        }
        this.session.save((Object)processDefinition);
    }

    public void saveProcessDefinition(ProcessDefinition processDefinition) {
        try {
            this.session.save((Object)processDefinition);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't save process definition '" + processDefinition + "'", e);
        }
    }

    public ProcessDefinition loadProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.load(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process definition '" + processDefinitionId + "'", e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.get(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process definition '" + processDefinitionId + "'", e);
        }
    }

    public ProcessDefinition findProcessDefinition(String name, int version) {
        ProcessDefinition processDefinition = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findProcessDefinitionByNameAndVersion");
            query.setString("name", name);
            query.setInteger("version", version);
            processDefinition = (ProcessDefinition)query.uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process definition with name '" + name + "' and version '" + version + "'", e);
        }
        return processDefinition;
    }

    public ProcessDefinition findLatestProcessDefinition(String name) {
        ProcessDefinition processDefinition = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findLatestProcessDefinitionQuery");
            query.setString("name", name);
            query.setMaxResults(1);
            processDefinition = (ProcessDefinition)query.uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find process definition '" + name + "'", e);
        }
        return processDefinition;
    }

    public List findLatestProcessDefinitions() {
        ArrayList<Object> processDefinitions = new ArrayList();
        HashMap<String, ProcessDefinition> processDefinitionsByName = new HashMap<String, ProcessDefinition>();
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessDefinitions");
            Iterator iter = query.list().iterator();
            while (iter.hasNext()) {
                ProcessDefinition processDefinition = (ProcessDefinition)iter.next();
                String processDefinitionName = processDefinition.getName();
                ProcessDefinition previous = (ProcessDefinition)processDefinitionsByName.get(processDefinitionName);
                if (previous != null && previous.getVersion() >= processDefinition.getVersion()) continue;
                processDefinitionsByName.put(processDefinitionName, processDefinition);
            }
            processDefinitions = new ArrayList(processDefinitionsByName.values());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find latest versions of process definitions", e);
        }
        return processDefinitions;
    }

    public List findAllProcessDefinitions() {
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessDefinitions");
            return query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find all process definitions", e);
        }
    }

    public List findAllProcessDefinitionVersions(String name) {
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessDefinitionVersions");
            query.setString("name", name);
            return query.list();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new JbpmException("couldn't find all versions of process definition '" + name + "'", e);
        }
    }

    public void deleteProcessDefinition(long processDefinitionId) {
        this.deleteProcessDefinition(this.loadProcessDefinition(processDefinitionId));
    }

    public void deleteProcessDefinition(ProcessDefinition processDefinition) {
        if (processDefinition == null) {
            throw new JbpmException("processDefinition is null in JbpmSession.deleteProcessDefinition()");
        }
        try {
            List processInstances = this.findProcessInstances(processDefinition.getId());
            if (processInstances != null) {
                Iterator iter = processInstances.iterator();
                while (iter.hasNext()) {
                    this.deleteProcessInstance((ProcessInstance)iter.next());
                }
            }
            this.session.delete((Object)processDefinition);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete process definition '" + processDefinition.getId() + "'", e);
        }
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        throw new UnsupportedOperationException("use JbpmContext.save(ProcessInstance) instead");
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        try {
            ProcessInstance processInstance = (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
            return processInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process instance '" + processInstanceId + "'", e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        try {
            ProcessInstance processInstance = (ProcessInstance)this.session.get(ProcessInstance.class, (Serializable)new Long(processInstanceId));
            return processInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process instance '" + processInstanceId + "'", e);
        }
    }

    public Token loadToken(long tokenId) {
        try {
            Token token = (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load token '" + tokenId + "'", e);
        }
    }

    public Token getToken(long tokenId) {
        try {
            Token token = (Token)this.session.get(Token.class, (Serializable)new Long(tokenId));
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get token '" + tokenId + "'", e);
        }
    }

    public void lockProcessInstance(long processInstanceId) {
        this.lockProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void lockProcessInstance(ProcessInstance processInstance) {
        try {
            this.session.lock((Object)processInstance, LockMode.UPGRADE);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't lock process instance '" + processInstance.getId() + "'", e);
        }
    }

    public List findProcessInstances(long processDefinitionId) {
        List processInstances = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessInstancesForADefinition");
            query.setLong("processDefinitionId", processDefinitionId);
            processInstances = query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process instances for process definition '" + processDefinitionId + "'", e);
        }
        return processInstances;
    }

    public void deleteProcessInstance(long processInstanceId) {
        this.deleteProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void deleteProcessInstance(ProcessInstance processInstance) {
        this.deleteProcessInstance(processInstance, true, true, true);
    }

    public void deleteProcessInstance(ProcessInstance processInstance, boolean includeTasks, boolean includeTimers, boolean includeMessages) {
        if (processInstance == null) {
            throw new JbpmException("processInstance is null in JbpmSession.deleteProcessInstance()");
        }
        try {
            Query query = this.session.getNamedQuery("GraphSession.findTokensForProcessInstance");
            query.setEntity("processInstance", (Object)processInstance);
            List tokens = query.list();
            Iterator iter = tokens.iterator();
            while (iter.hasNext()) {
                Token token = (Token)iter.next();
                this.deleteSubProcesses(token);
                if (!includeMessages) continue;
                query = this.session.getNamedQuery("GraphSession.deleteMessagesForToken");
                query.setEntity("token", (Object)token);
                query.executeUpdate();
            }
            if (includeTasks) {
                query = this.session.getNamedQuery("GraphSession.findTaskInstanceIdsForProcessInstance");
                query.setEntity("processInstance", (Object)processInstance);
                List taskInstanceIds = query.list();
                query = this.session.getNamedQuery("GraphSession.deleteTaskInstancesById");
                query.setParameterList("taskInstanceIds", (Collection)taskInstanceIds);
            }
            if (includeTimers) {
                query = this.session.getNamedQuery("SchedulerSession.deleteTimersForProcessInstance");
                query.setEntity("processInstance", (Object)processInstance);
                query.executeUpdate();
            }
            if (tokens != null && !tokens.isEmpty()) {
                query = this.session.getNamedQuery("GraphSession.selectLogsForTokens");
                query.setParameterList("tokens", (Collection)tokens);
                List logs = query.list();
                iter = logs.iterator();
                while (iter.hasNext()) {
                    this.session.delete(iter.next());
                }
            }
            this.session.delete((Object)processInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete process instance '" + processInstance.getId() + "'", e);
        }
    }

    void deleteSubProcesses(Token token) {
        ProcessInstance subProcessInstance = token.getSubProcessInstance();
        if (subProcessInstance != null) {
            subProcessInstance.setSuperProcessToken(null);
            token.setSubProcessInstance(null);
            this.deleteProcessInstance(subProcessInstance);
        }
        if (token.getChildren() != null) {
            Iterator iter = token.getChildren().values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                this.deleteSubProcesses(child);
            }
        }
    }

    public List findActiveNodesByProcessInstance(ProcessInstance processInstance) {
        List results = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findActiveNodesByProcessInstance");
            query.setEntity("processInstance", (Object)processInstance);
            results = query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't active nodes for process instance '" + processInstance + "'", e);
        }
        return results;
    }
}

