/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.ant.types.attributes.Version;

public class VersionTest
extends TestCase {
    Version newversion1 = new Version("1");
    Version newversion2 = new Version("1.1");
    Version newversion3 = new Version("1.1.2");
    Version newversion4 = new Version("ruel");
    Version newversion5 = new Version("ruel.1");
    Version newversion6 = new Version("ruel.1jboss");
    Version newversion7 = new Version("ruel.1jbossa");
    Version newversion8 = new Version("1.1.2");

    public void testComparison() {
        int test1 = this.newversion1.compareTo(this.newversion2);
        int test2 = this.newversion1.compareTo(this.newversion3);
        int test3 = this.newversion2.compareTo(this.newversion3);
        int test4 = this.newversion1.compareTo(this.newversion4);
        int test5 = this.newversion4.compareTo(this.newversion5);
        int test6 = this.newversion5.compareTo(this.newversion6);
        int test7 = this.newversion6.compareTo(this.newversion7);
        int test8 = this.newversion3.compareTo(this.newversion8);
        Assert.assertTrue((test1 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test2 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test3 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test4 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test5 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test6 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test7 < 0 ? 1 : 0) != 0);
        Assert.assertTrue((test8 == 0 ? 1 : 0) != 0);
    }

    public void testComparisonRefactored() {
        this.assertLessThan("1", "1.1");
        this.assertLessThan("1", "1.1.2");
        this.assertLessThan("1.1", "1.1.2");
        this.assertLessThan("1", "ruel");
        this.assertLessThan("ruel", "ruel.1");
        this.assertLessThan("ruel.1", "ruel.1jbossa");
        this.assertLessThan("ruel.1jboss", "ruel.1jbossa");
        this.assertEqual("1.1.2", "1.1.2");
    }

    public void testWordAgainstNumberBug() {
        this.assertLessThan("1.1.2", "ruel");
    }

    public void testNewVersionPolicy() {
        this.assertLessThan("1.0RC2", "1.0.0.CR3");
    }

    public void testNewVersionPolicyReversed() {
        this.assertGreaterThan("1.0.0.CR3", "1.0RC2");
    }

    public void testSnapshot() {
        this.assertGreaterThan("snapshot", "1.0.0.CR3");
    }

    public void testJBossPatchedVersion() {
        this.assertLessThan("1.0.4jboss", "1.0.4.1jboss");
    }

    public void testSuccessionMatrix() {
        String[] matrix = new String[]{"1.0.0.Alpha", "1.0.0.Alpha1", "1.0.0.Alpha2", "1.0.0.Alpha3", "1.0.0.Beta", "1.0.0.Beta1", "1.0.0.Beta2", "1.0.0.Beta3", "1.0.0.CR", "1.0.0.CR1", "1.0.0.CR2", "1.0.0.CR3", "1.0.0.GA", "1.0.0.SP", "1.0.0.SP1", "1.0.0.SP2", "snapshot"};
        this.assertMatrixOrder(matrix);
    }

    private void assertMatrixOrder(String[] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix.length) {
                if (i < j) {
                    this.assertLessThan(matrix[i], matrix[j]);
                    this.assertGreaterThan(matrix[j], matrix[i]);
                } else if (i > j) {
                    this.assertLessThan(matrix[j], matrix[i]);
                    this.assertGreaterThan(matrix[i], matrix[j]);
                } else {
                    Assert.assertEquals((String)matrix[j], (String)matrix[i]);
                    Assert.assertEquals((String)matrix[i], (String)matrix[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void assertLessThan(String version1, String version2) {
        Version versionOne = new Version(version1);
        Version versionTwo = new Version(version2);
        Assert.assertTrue((String)(String.valueOf(version1) + " should be less than " + version2), (versionOne.compareTo(versionTwo) < 0 ? 1 : 0) != 0);
    }

    private void assertGreaterThan(String version1, String version2) {
        Version versionOne = new Version(version1);
        Version versionTwo = new Version(version2);
        Assert.assertTrue((String)(String.valueOf(version1) + " should be greater than " + version2), (versionOne.compareTo(versionTwo) > 0 ? 1 : 0) != 0);
    }

    private void assertEqual(String version1, String version2) {
        Version versionOne = new Version(version1);
        Version versionTwo = new Version(version2);
        Assert.assertTrue((String)(String.valueOf(version1) + " should equal " + version2), (versionOne.compareTo(versionTwo) == 0 ? 1 : 0) != 0);
    }
}

