/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.graph.ComponentRefVertex;
import org.jboss.ant.util.graph.Edge;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.Vertex;
import org.jboss.ant.util.graph.Visitor;

public class ComponentRefGraphClasspathVisitor
implements Visitor {
    private BufferedWriter bufferedWriter;
    private HashMap map = new HashMap();
    private Project project;

    public ComponentRefGraphClasspathVisitor(Project project) {
        this.project = project;
    }

    public void visit(Graph g, Vertex v) {
        this.project.log("ComponentRefGraphClasspathVisitor.visit: " + v.getName() + ", type: " + v.getClass(), 3);
        if (v instanceof ComponentRefVertex) {
            ComponentRefVertex componentRefVertex = (ComponentRefVertex)v;
            Component component = componentRefVertex.getComponentRef().getComponent();
            String pathName = component.getId();
            this.project.log("Checking component: " + pathName, 3);
            if (this.getMap().get(pathName) != null) {
                return;
            }
            this.getMap().put(pathName, component);
            this.project.log("Generating classpath for: " + pathName, 3);
            try {
                if (pathName.indexOf(45) != -1 || pathName.indexOf(47) != -1) {
                    if (pathName.indexOf(45) != -1) {
                        pathName = pathName.replace('-', '.');
                    }
                    if (pathName.indexOf(47) != -1) {
                        pathName = pathName.replace('/', '.');
                    }
                } else {
                    pathName = String.valueOf(pathName) + '.' + pathName;
                }
                this.bufferedWriter.write("<!-- " + component.getId() + " -->");
                this.bufferedWriter.newLine();
                this.bufferedWriter.write("<property name=\"" + pathName + ".root\" value=\"${project.thirdparty}/" + component.getId() + "\"/>");
                this.bufferedWriter.newLine();
                this.bufferedWriter.write("<property name=\"" + pathName + ".lib\" value=\"${" + pathName + ".root}/" + "lib/\"/>");
                this.bufferedWriter.newLine();
                this.bufferedWriter.write("<property name=\"" + pathName + ".resources\" value=\"${" + pathName + ".root}/" + "resources/\"/>");
                this.bufferedWriter.newLine();
                this.bufferedWriter.write("<path id=\"" + pathName + ".classpath\">");
                this.bufferedWriter.newLine();
                int i = 0;
                while (i < component.getExport().getOutputs().size()) {
                    File output = (File)component.getExport().getOutputs().get(i);
                    this.bufferedWriter.write("   <pathelement path=\"${" + pathName + ".lib}/" + output.getName() + "\"/>");
                    this.bufferedWriter.newLine();
                    ++i;
                }
                this.bufferedWriter.write("</path>");
                this.bufferedWriter.newLine();
                this.bufferedWriter.newLine();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                throw new BuildException("Error adding information to file ", (Throwable)e);
            }
        }
    }

    public void visit(Graph g, Vertex v, Edge e) {
    }

    public BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public void setBufferedWriter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    public HashMap getMap() {
        return this.map;
    }
}

