/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.util.FileUtils;

public abstract class FileUtil {
    private static FileUtils fileUtils = FileUtils.newFileUtils();

    public static File resolve(File file, String name) {
        return fileUtils.resolveFile(file, name);
    }

    public static File getRoot(Project project) {
        if (project.getBaseDir().getParentFile().getName().equalsIgnoreCase("jbossas")) {
            return project.getBaseDir().getParentFile().getParentFile();
        }
        if (project.getProperty("external.project") != null) {
            return project.getBaseDir();
        }
        return project.getBaseDir().getParentFile();
    }

    public static URL resolve(URL url, String name) throws MalformedURLException {
        return new URL(url + "/" + name);
    }

    public static void mkdir(File directory, Project project) {
        Mkdir mkdir = new Mkdir();
        mkdir.setTaskName("mkdir");
        mkdir.setProject(project);
        mkdir.setDir(directory);
        mkdir.execute();
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String readFile(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            int x = fis.available();
            byte[] b = new byte[x];
            fis.read(b);
            String content = new String(b);
            return content;
        }
        catch (IOException e) {
            throw new BuildException("Error reading contents of file: " + file.getAbsolutePath());
        }
    }

    private FileUtil() {
    }
}

