/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.deployment;

import org.apache.tools.ant.BuildException;
import org.jboss.ant.types.AbstractDataType;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.build.Component;

public class Deployment
extends AbstractDataType {
    private Build build;
    private String artifact;
    private String outputPath;
    private String requiredJDK = "default";
    private String exploded = "false";
    private String overwrite;
    private String toName;
    private String component;

    protected void doValidate() {
        if (this.artifact == null) {
            throw new BuildException("An artifact must be defined for each deployment");
        }
        if (this.component == null) {
            throw new BuildException("A component must be defined for deployment with artifact: " + this.artifact);
        }
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getArtifactId() {
        return this.artifact;
    }

    public Artifact getArtifact() {
        int i = 0;
        while (i < Build.getBuild().getComponents().size()) {
            Component currentComponent = (Component)((Object)Build.getBuild().getComponents().elementAt(i));
            if (currentComponent.getId().equalsIgnoreCase(this.component)) {
                int j = 0;
                while (j < currentComponent.getArtifacts().size()) {
                    Artifact currentArtifact = (Artifact)((Object)currentComponent.getArtifacts().elementAt(j));
                    if (currentArtifact.getId().equalsIgnoreCase(this.artifact)) {
                        return currentArtifact;
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new BuildException("Unable to locate artifact with id: " + this.artifact + " belonging to component: " + this.component);
    }

    public String getRequiredJDK() {
        return this.requiredJDK;
    }

    public void setRequiredJDK(String requiredJDK) {
        this.requiredJDK = requiredJDK;
    }

    public String getExploded() {
        return this.exploded;
    }

    public void setExploded(String exploded) {
        this.exploded = exploded;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public String getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(String overwrite) {
        this.overwrite = overwrite;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }
}

