/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunTest
extends Task {
    String basedir;
    String testsuite = "";
    String referenceJar = "";
    String refVersion = "";
    static /* synthetic */ Class class$java$lang$String;

    public void setTestSuite(String str) {
        this.testsuite = str;
    }

    public void setBasedir(String str) {
        this.basedir = str;
    }

    public void setReference(String str) {
        this.referenceJar = str;
    }

    public void setRefVersion(String str) {
        this.refVersion = str;
    }

    public void execute() throws BuildException {
        this.runReference();
        this.testNewBuild();
    }

    protected void testNewBuild() {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file:build/fop.jar")});
            HashMap diff = this.runConverter(loader, "areatree", "reference/output/");
            if (diff != null && !diff.isEmpty()) {
                System.out.println("====================================");
                System.out.println("The following files differ:");
                boolean broke = false;
                Iterator keys = diff.keySet().iterator();
                while (keys.hasNext()) {
                    Object fname = keys.next();
                    Boolean pass = (Boolean)diff.get(fname);
                    System.out.println("file: " + fname + " - reference success: " + pass);
                    if (!pass.booleanValue()) continue;
                    broke = true;
                }
                if (broke) {
                    throw new BuildException("Working tests have been changed.");
                }
            }
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    protected void runReference() throws BuildException {
        File f = new File(this.basedir + "/reference/output/");
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file:" + this.referenceJar)});
            boolean failed = false;
            try {
                Class<?> cla = Class.forName("org.apache.fop.apps.Options", true, loader);
                Object opts = cla.newInstance();
                cla = Class.forName("org.apache.fop.apps.Version", true, loader);
                Method get = cla.getMethod("getVersion", new Class[0]);
                if (!get.invoke(null, new Object[0]).equals(this.refVersion)) {
                    throw new BuildException("Reference jar is not correct version it must be: " + this.refVersion);
                }
            }
            catch (IllegalAccessException iae) {
                failed = true;
            }
            catch (IllegalArgumentException are) {
                failed = true;
            }
            catch (InvocationTargetException are) {
                failed = true;
            }
            catch (ClassNotFoundException are) {
                failed = true;
            }
            catch (InstantiationException are) {
                failed = true;
            }
            catch (NoSuchMethodException are) {
                failed = true;
            }
            if (failed) {
                throw new BuildException("Reference jar could not be found in: " + this.basedir + "/reference/");
            }
            f.mkdirs();
            this.runConverter(loader, "reference/output/", null);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    protected HashMap runConverter(ClassLoader loader, String dest, String compDir) {
        String converter = "org.apache.fop.tools.TestConverter";
        HashMap diff = null;
        try {
            Class<?> cla = Class.forName(converter, true, loader);
            Object tc = cla.newInstance();
            Method meth = cla.getMethod("setBaseDir", class$java$lang$String == null ? (class$java$lang$String = RunTest.class$("java.lang.String")) : class$java$lang$String);
            meth.invoke(tc, this.basedir);
            meth = cla.getMethod("runTests", class$java$lang$String == null ? (class$java$lang$String = RunTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RunTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RunTest.class$("java.lang.String")) : class$java$lang$String);
            diff = (HashMap)meth.invoke(tc, this.testsuite, dest, compDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return diff;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

