/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;

public class PDFEncryption
extends PDFObject {
    static final char[] pad = new char[]{'(', '\u00bf', 'N', '^', 'N', 'u', '\u008a', 'A', 'd', '\u0000', 'N', 'V', '\u00ff', '\u00fa', '\u0001', '\b', '.', '.', '\u0000', '\u00b6', '\u00d0', 'h', '>', '\u0080', '/', '\f', '\u00a9', '\u00fe', 'd', 'S', 'i', 'z'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int PERMISSION_PRINT = 4;
    public static final int PERMISSION_EDIT_CONTENT = 8;
    public static final int PERMISSION_COPY_CONTENT = 16;
    public static final int PERMISSION_EDIT_ANNOTATIONS = 32;
    MessageDigest digest = null;
    Cipher cipher = null;
    Random random = new Random();
    String userPassword = "";
    String ownerPassword = "";
    boolean allowPrint = true;
    boolean allowCopyContent = true;
    boolean allowEditContent = true;
    boolean allowEditAnnotations = true;
    byte[] fileID = null;
    byte[] encryptionKey = null;
    String dictionary = null;

    public PDFEncryption(int number) {
        super(number);
        try {
            this.digest = MessageDigest.getInstance("MD5");
            this.cipher = Cipher.getInstance("RC4");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setUserPassword(String value) {
        this.userPassword = value;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setOwnerPassword(String value) {
        this.ownerPassword = value;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    public void setAllowPrint(boolean value) {
        this.allowPrint = value;
    }

    public void setAllowCopyContent(boolean value) {
        this.allowCopyContent = value;
    }

    public void setAllowEditContent(boolean value) {
        this.allowEditContent = value;
    }

    public void setAllowEditAnnotation(boolean value) {
        this.allowEditAnnotations = value;
    }

    private byte[] prepPassword(String password) {
        int i;
        byte[] obuffer = new byte[32];
        byte[] pbuffer = password.getBytes();
        int j = 0;
        for (i = 0; i < obuffer.length && i < pbuffer.length; ++i) {
            obuffer[i] = pbuffer[i];
        }
        while (i < obuffer.length) {
            obuffer[i++] = (byte)pad[j++];
        }
        return obuffer;
    }

    private String toHex(byte[] value) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            buffer.append(digits[value[i] >>> 4 & 0xF]);
            buffer.append(digits[value[i] & 0xF]);
        }
        return buffer.toString();
    }

    public byte[] getFileID() {
        if (this.fileID == null) {
            this.fileID = new byte[16];
            this.random.nextBytes(this.fileID);
        }
        return this.fileID;
    }

    public String getFileID(int index) {
        if (index == 1) {
            return this.toHex(this.getFileID());
        }
        byte[] id = new byte[16];
        this.random.nextBytes(id);
        return this.toHex(id);
    }

    private byte[] encryptWithKey(byte[] data, byte[] key) {
        try {
            SecretKeySpec keyspec = new SecretKeySpec(key, "RC4");
            this.cipher.init(1, keyspec);
            return this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private byte[] encryptWithHash(byte[] data, byte[] hash, int size) {
        hash = this.digest.digest(hash);
        byte[] key = new byte[size];
        for (int i = 0; i < size; ++i) {
            key[i] = hash[i];
        }
        return this.encryptWithKey(data, key);
    }

    public void init() {
        byte[] oValue = this.ownerPassword.length() > 0 ? this.encryptWithHash(this.prepPassword(this.userPassword), this.prepPassword(this.ownerPassword), 5) : this.encryptWithHash(this.prepPassword(this.userPassword), this.prepPassword(this.userPassword), 5);
        int permissions = -4;
        if (!this.allowPrint) {
            permissions -= 4;
        }
        if (!this.allowCopyContent) {
            permissions -= 16;
        }
        if (!this.allowEditContent) {
            permissions -= 8;
        }
        if (!this.allowEditAnnotations) {
            permissions -= 32;
        }
        this.digest.update(this.prepPassword(this.userPassword));
        this.digest.update(oValue);
        this.digest.update((byte)(permissions >>> 0));
        this.digest.update((byte)(permissions >>> 8));
        this.digest.update((byte)(permissions >>> 16));
        this.digest.update((byte)(permissions >>> 24));
        this.digest.update(this.getFileID());
        byte[] hash = this.digest.digest();
        this.encryptionKey = new byte[5];
        for (int i = 0; i < 5; ++i) {
            this.encryptionKey[i] = hash[i];
        }
        byte[] uValue = this.encryptWithKey(this.prepPassword(""), this.encryptionKey);
        this.dictionary = this.number + " " + this.generation + " obj\n<< /Filter /Standard\n" + "/V 1" + "/R 2" + "/Length 40" + "/P " + permissions + "\n" + "/O <" + this.toHex(oValue) + ">\n" + "/U <" + this.toHex(uValue) + ">\n" + ">>\n" + "endobj\n";
    }

    public byte[] encryptData(byte[] data, int number, int generation) {
        if (this.encryptionKey == null) {
            throw new IllegalStateException("PDF Encryption has not been initialized");
        }
        byte[] hash = new byte[this.encryptionKey.length + 5];
        for (int i = 0; i < this.encryptionKey.length; ++i) {
            hash[i] = this.encryptionKey[i];
        }
        hash[i++] = (byte)(number >>> 0);
        hash[i++] = (byte)(number >>> 8);
        hash[i++] = (byte)(number >>> 16);
        hash[i++] = (byte)(generation >>> 0);
        hash[i++] = (byte)(generation >>> 8);
        return this.encryptWithHash(data, hash, hash.length);
    }

    public PDFFilter makeFilter(int number, int generation) {
        return new EncryptionFilter(this, number, generation);
    }

    public byte[] toPDF() throws IllegalStateException {
        if (this.dictionary == null) {
            throw new IllegalStateException("PDF Encryption has not been initialized");
        }
        try {
            return this.dictionary.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return this.dictionary.getBytes();
        }
    }

    public static boolean encryptionAvailable() {
        return true;
    }

    private class EncryptionFilter
    extends PDFFilter {
        PDFEncryption encryption;
        int number;
        int generation;

        public EncryptionFilter(PDFEncryption encryption, int number, int generation) {
            this.encryption = encryption;
            this.number = number;
            this.generation = generation;
        }

        public String getName() {
            return "";
        }

        public String getDecodeParms() {
            return null;
        }

        public byte[] encode(byte[] data) {
            return this.encryption.encryptData(data, this.number, this.generation);
        }
    }
}

