/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layout.RegionArea;

public abstract class Region
extends FObj {
    public static final String PROP_REGION_NAME = "region-name";
    private SimplePageMaster _layoutMaster;
    private String _regionName;

    protected Region(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (null == this.properties.get(PROP_REGION_NAME)) {
            this.setRegionName(this.getDefaultRegionName());
        } else if (this.properties.get(PROP_REGION_NAME).getString().equals("")) {
            this.setRegionName(this.getDefaultRegionName());
        } else {
            this.setRegionName(this.properties.get(PROP_REGION_NAME).getString());
            if (this.isReserved(this.getRegionName()) && !this.getRegionName().equals(this.getDefaultRegionName())) {
                throw new FOPException("region-name '" + this._regionName + "' for " + this.getName() + " not permitted.", systemId, line, column);
            }
        }
        if (!parent.getName().equals("fo:simple-page-master")) {
            throw new FOPException(this.getName() + " must be child " + "of simple-page-master, not " + parent.getName(), systemId, line, column);
        }
        this._layoutMaster = (SimplePageMaster)parent;
        this.getPageMaster().addRegion(this);
    }

    abstract RegionArea makeRegionArea(int var1, int var2, int var3, int var4);

    protected abstract String getDefaultRegionName();

    public abstract String getRegionClass();

    public String getRegionName() {
        return this._regionName;
    }

    private void setRegionName(String name) {
        this._regionName = name;
    }

    protected SimplePageMaster getPageMaster() {
        return this._layoutMaster;
    }

    protected boolean isReserved(String name) throws FOPException {
        return name.equals("xsl-region-before") || name.equals("xsl-region-start") || name.equals("xsl-region-end") || name.equals("xsl-region-after") || name.equals("xsl-before-float-separator") || name.equals("xsl-footnote-separator");
    }

    public boolean generatesReferenceAreas() {
        return true;
    }
}

