/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.Attributes;

public class PropertyListBuilder {
    private static final String FONTSIZEATTR = "font-size";
    private HashMap propertyListTable = new HashMap();
    private HashMap elementTable = new HashMap();

    public void addList(HashMap list) {
        this.propertyListTable.putAll(list);
    }

    public void addElementList(String element, HashMap list) {
        this.elementTable.put(element, list);
    }

    public Property computeProperty(PropertyList propertyList, String space, String element, String propertyName) {
        Property p = null;
        Property.Maker propertyMaker = this.findMaker(space, element, propertyName);
        if (propertyMaker != null) {
            try {
                p = propertyMaker.compute(propertyList);
            }
            catch (FOPException e) {
                MessageHandler.errorln("exception occurred while computing value of property '" + propertyName + "': " + e.getMessage());
            }
        } else {
            MessageHandler.errorln("property " + propertyName + " ignored");
        }
        return p;
    }

    public boolean isInherited(String space, String element, String propertyName) {
        Property.Maker propertyMaker = this.findMaker(space, element, propertyName);
        boolean b = propertyMaker != null ? propertyMaker.isInherited() : true;
        return b;
    }

    public PropertyList makeList(String ns, String elementName, Attributes attributes, PropertyList parentPropertyList, FObj parentFO) throws FOPException {
        String space = "http://www.w3.org/TR/1999/XSL/Format";
        if (ns != null) {
            space = ns;
        }
        PropertyList par = null;
        if (parentPropertyList != null && space.equals(parentPropertyList.getNameSpace())) {
            par = parentPropertyList;
        }
        PropertyList p = new PropertyList(par, space, elementName);
        p.setBuilder(this);
        HashMap table = (HashMap)this.elementTable.get(elementName);
        StringBuffer propsDone = new StringBuffer(256);
        propsDone.append(' ');
        String fontsizeval = attributes.getValue(FONTSIZEATTR);
        if (fontsizeval != null) {
            Property.Maker propertyMaker = this.findMaker(table, FONTSIZEATTR);
            if (propertyMaker != null) {
                try {
                    p.put(FONTSIZEATTR, propertyMaker.make(p, fontsizeval, parentFO));
                }
                catch (FOPException e) {
                    // empty catch block
                }
            }
            propsDone.append("font-size ");
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            int sepchar = attributeName.indexOf(46);
            String propName = attributeName;
            String subpropName = null;
            Property propVal = null;
            if (sepchar > -1) {
                propName = attributeName.substring(0, sepchar);
                subpropName = attributeName.substring(sepchar + 1);
            } else if (propsDone.toString().indexOf(' ' + propName + ' ') != -1) continue;
            Property.Maker propertyMaker = this.findMaker(table, propName);
            if (propertyMaker != null) {
                try {
                    if (subpropName != null) {
                        String baseValue;
                        Property baseProp = p.getExplicitBaseProp(propName);
                        if (baseProp == null && (baseValue = attributes.getValue(propName)) != null) {
                            baseProp = propertyMaker.make(p, baseValue, parentFO);
                            propsDone.append(propName + ' ');
                        }
                        propVal = propertyMaker.make(baseProp, subpropName, p, attributes.getValue(i), parentFO);
                    } else {
                        propVal = propertyMaker.make(p, attributes.getValue(i), parentFO);
                    }
                    if (propVal == null) continue;
                    p.put(propName, propVal);
                }
                catch (FOPException e) {
                    MessageHandler.errorln(e.getMessage());
                }
                continue;
            }
            if (attributeName.startsWith("xmlns")) continue;
            MessageHandler.errorln("property '" + attributeName + "' ignored");
        }
        return p;
    }

    public Property getSubpropValue(String space, String element, String propertyName, Property p, String subpropName) {
        Property.Maker maker = this.findMaker(space, element, propertyName);
        if (maker != null) {
            return maker.getSubpropValue(p, subpropName);
        }
        return null;
    }

    public boolean isCorrespondingForced(PropertyList propertyList, String space, String element, String propertyName) {
        Property.Maker propertyMaker = this.findMaker(space, element, propertyName);
        if (propertyMaker != null) {
            return propertyMaker.isCorrespondingForced(propertyList);
        }
        MessageHandler.errorln("no Maker for " + propertyName);
        return false;
    }

    public Property getShorthand(PropertyList propertyList, String space, String element, String propertyName) {
        Property.Maker propertyMaker = this.findMaker(space, element, propertyName);
        if (propertyMaker != null) {
            return propertyMaker.getShorthand(propertyList);
        }
        MessageHandler.errorln("no Maker for " + propertyName);
        return null;
    }

    public Property makeProperty(PropertyList propertyList, String space, String element, String propertyName) throws FOPException {
        Property p = null;
        Property.Maker propertyMaker = this.findMaker(space, element, propertyName);
        if (propertyMaker != null) {
            p = propertyMaker.make(propertyList);
        } else {
            MessageHandler.errorln("property " + propertyName + " ignored");
        }
        return p;
    }

    protected Property.Maker findMaker(String space, String elementName, String propertyName) {
        return this.findMaker((HashMap)this.elementTable.get(elementName), propertyName);
    }

    private Property.Maker findMaker(HashMap elemTable, String propertyName) {
        Property.Maker propertyMaker = null;
        if (elemTable != null) {
            propertyMaker = (Property.Maker)elemTable.get(propertyName);
        }
        if (propertyMaker == null) {
            propertyMaker = (Property.Maker)this.propertyListTable.get(propertyName);
        }
        return propertyMaker;
    }
}

