/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibOrderedDitherOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

public class MlibOrderedDitherRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        ColorCube colorCube = (ColorCube)parameterBlock.getObjectParameter(0);
        KernelJAI[] kernelJAIArray = (KernelJAI[])parameterBlock.getObjectParameter(1);
        if (colorCube.getNumBands() != 1 && colorCube.getNumBands() != 3) {
            return null;
        }
        if (colorCube.getDataType() != 0) {
            return null;
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getDataType() != 0) {
            return null;
        }
        if (sampleModel.getNumBands() != colorCube.getNumBands()) {
            return null;
        }
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        ImageLayout imageLayout2 = MlibOrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube);
        SampleModel sampleModel2 = imageLayout2.getSampleModel(null);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, true) || !MediaLibAccessor.isMediaLibCompatible(sampleModel2, null, true)) {
            return null;
        }
        return new MlibOrderedDitherOpImage(renderedImage, renderingHints, imageLayout2, colorCube, kernelJAIArray);
    }
}

