/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.GenericValueContainer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.group.ValueList;
import org.jboss.xb.binding.group.ValueListHandler;
import org.jboss.xb.binding.group.ValueListInitializer;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.MapEntry;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil;
import org.xml.sax.Attributes;

public class RtElementHandler
implements ElementHandler {
    private static final Logger log = Logger.getLogger(RtElementHandler.class);
    public static final RtElementHandler INSTANCE = new RtElementHandler();

    public Object startElement(Object parent, QName elementName, ElementBinding element) {
        if (element.isSkip()) {
            return parent;
        }
        ArrayList o = null;
        TypeBinding type = element.getType();
        if (type.isStartElementCreatesObject()) {
            ClassMetaData classMetaData = element.getClassMetaData();
            MapEntryMetaData mapEntryMetaData = element.getMapEntryMetaData();
            if (classMetaData == null && type.isArrayWrapper() && element.getAddMethodMetaData() == null) {
                if (parent == null) {
                    Class itemCls;
                    ElementBinding item = type.getArrayItem();
                    TypeBinding itemType = item.getType();
                    QName itemTypeQName = itemType.getQName();
                    if (itemTypeQName != null && "http://www.w3.org/2001/XMLSchema".equals(itemTypeQName.getNamespaceURI())) {
                        itemCls = SimpleTypeBindings.classForType(itemType.getQName().getLocalPart(), item.isNillable());
                    } else {
                        ClassMetaData itemClsMetaData = itemType.getClassMetaData();
                        String itemClsName = itemClsMetaData == null ? null : itemClsMetaData.getImpl();
                        itemCls = RtElementHandler.getClass(itemClsName, item, item.getQName());
                    }
                    if (itemCls != null) {
                        o = GenericValueContainer.FACTORY.array(itemCls);
                    }
                } else {
                    Class<?> fieldType;
                    String getterName;
                    PropertyMetaData propertyMetaData = element.getPropertyMetaData();
                    String propName = propertyMetaData == null ? null : propertyMetaData.getName();
                    String string = getterName = propName == null ? Util.xmlNameToGetMethodName(elementName.getLocalPart(), element.getSchema().isIgnoreLowLine()) : "get" + propName.charAt(0) + propName.substring(1);
                    Class parentClass = parent instanceof GenericValueContainer ? ((GenericValueContainer)parent).getTargetClass() : (parent instanceof ValueList ? ((ValueList)parent).getTargetClass() : parent.getClass());
                    try {
                        Method getter = parentClass.getMethod(getterName, null);
                        fieldType = getter.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        String fieldName = null;
                        try {
                            fieldName = propName == null ? Util.xmlNameToFieldName(elementName.getLocalPart(), element.getSchema().isIgnoreLowLine()) : propName;
                            Field field = parentClass.getField(fieldName);
                            fieldType = field.getType();
                        }
                        catch (NoSuchFieldException e1) {
                            throw new JBossXBRuntimeException("Failed to find field " + fieldName + " and getter " + getterName + " for element " + elementName + " in " + parentClass);
                        }
                    }
                    if (fieldType.isArray()) {
                        o = GenericValueContainer.FACTORY.array(fieldType.getComponentType());
                    } else if (Collection.class.isAssignableFrom(fieldType)) {
                        o = new ArrayList();
                    }
                }
            } else if (mapEntryMetaData != null) {
                if (mapEntryMetaData.getImpl() != null) {
                    Class cls = RtElementHandler.getClass(mapEntryMetaData.getImpl(), element, elementName);
                    o = RtElementHandler.newInstance(cls, elementName, type);
                } else {
                    o = new MapEntry();
                }
                if (mapEntryMetaData.isNonNullValue() && mapEntryMetaData.getValueType() != null) {
                    Object value;
                    Class<?> mapValueType;
                    try {
                        mapValueType = Thread.currentThread().getContextClassLoader().loadClass(mapEntryMetaData.getValueType());
                    }
                    catch (ClassNotFoundException e) {
                        throw new JBossXBRuntimeException("startElement failed for " + elementName + ": failed to load class " + mapEntryMetaData.getValueType() + " for map entry value.");
                    }
                    try {
                        value = mapValueType.newInstance();
                    }
                    catch (Exception e) {
                        throw new JBossXBRuntimeException("startElement failed for " + elementName + ": failed to create an instance of " + mapValueType + " for map entry value.");
                    }
                    if (o instanceof MapEntry) {
                        ((MapEntry)((Object)o)).setValue(value);
                    } else {
                        Method setValueMethod;
                        Method getValueMethod;
                        String setValueMethodName;
                        String getValueMethodName = mapEntryMetaData.getGetValueMethod();
                        if (getValueMethodName == null) {
                            getValueMethodName = "getValue";
                        }
                        if ((setValueMethodName = mapEntryMetaData.getSetValueMethod()) == null) {
                            setValueMethodName = "setValue";
                        }
                        try {
                            getValueMethod = o.getClass().getMethod(getValueMethodName, null);
                        }
                        catch (NoSuchMethodException e) {
                            throw new JBossXBRuntimeException("getValueMethod=" + getValueMethodName + " is not found in map entry " + o.getClass());
                        }
                        try {
                            setValueMethod = o.getClass().getMethod(setValueMethodName, getValueMethod.getReturnType());
                        }
                        catch (NoSuchMethodException e) {
                            throw new JBossXBRuntimeException("setValueMethod=" + setValueMethodName + "(" + getValueMethod.getReturnType().getName() + " value) is not found in map entry " + o.getClass());
                        }
                        try {
                            setValueMethod.invoke(o, value);
                        }
                        catch (Exception e) {
                            throw new JBossXBRuntimeException("setValueMethod=" + setValueMethodName + " failed: owner=" + o + ", value=" + value + ", msg=" + e.getMessage(), e);
                        }
                    }
                }
            } else {
                String clsName = classMetaData == null ? null : classMetaData.getImpl();
                Class cls = RtElementHandler.getClass(clsName, element, elementName);
                if (cls != null) {
                    o = RtElementHandler.newInstance(cls, elementName, type);
                }
            }
        }
        return o;
    }

    public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        TypeBinding type = element.getType();
        for (int i = 0; i < attrs.getLength(); ++i) {
            CharactersHandler simpleType;
            Object value;
            QName attrName = new QName(attrs.getURI(i), attrs.getLocalName(i));
            AttributeBinding binding = type.getAttribute(attrName);
            if (binding != null) {
                AttributeHandler handler = binding.getHandler();
                if (handler != null) {
                    value = handler.unmarshal(elementName, attrName, binding, nsCtx, attrs.getValue(i));
                    handler.attribute(elementName, attrName, binding, o, value);
                    continue;
                }
                throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + elementName + ", attrinute=" + attrName);
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(i)) || (simpleType = type.getSimpleType()) != null) continue;
            value = attrs.getValue(i);
            RtUtil.set(o, attrName, value, element.getSchema().isIgnoreLowLine());
        }
    }

    public Object endElement(Object o, QName elementName, ElementBinding element) {
        if (element.isSkip()) {
            return o;
        }
        if (o instanceof GenericValueContainer) {
            try {
                o = ((GenericValueContainer)o).instantiate();
            }
            catch (RuntimeException e) {
                throw new JBossXBRuntimeException("Container failed to create an instance for " + elementName + ": " + e.getMessage(), e);
            }
        } else if (o instanceof ValueList) {
            ValueList valueList = (ValueList)o;
            o = valueList.getHandler().newInstance(valueList);
        }
        return o;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParent(Object parent, Object o, QName qName, ElementBinding element, ElementBinding parentElement) {
        String propName;
        MapEntry mapEntry;
        if (element.isSkip()) {
            return;
        }
        if (element.isMapEntryKey()) {
            if (parent instanceof MapEntry) {
                MapEntry mapEntry2 = (MapEntry)parent;
                mapEntry2.setKey(o);
                return;
            } else {
                String setKeyMethodName;
                if (parentElement == null) throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key but parent element is not recognized as map entry and its metadata is not available.");
                MapEntryMetaData mapEntryMetaData = RtElementHandler.getMapEntryMetaData(parentElement, qName);
                String getKeyMethodName = mapEntryMetaData.getGetKeyMethod();
                if (getKeyMethodName == null) {
                    getKeyMethodName = "getKey";
                }
                if ((setKeyMethodName = mapEntryMetaData.getSetKeyMethod()) == null) {
                    setKeyMethodName = "setKey";
                }
                Class<?> parentCls = parent.getClass();
                Method setKeyMethod = RtElementHandler.getSetMethod(parentCls, getKeyMethodName, setKeyMethodName);
                RtElementHandler.invokeSetter(setKeyMethod, parent, o, setKeyMethodName);
            }
            return;
        }
        if (element.isMapEntryValue()) {
            if (parent instanceof MapEntry) {
                MapEntry mapEntry3 = (MapEntry)parent;
                mapEntry3.setValue(o);
                return;
            } else {
                if (parentElement == null) throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key but parent element is not recognized as map entry and its metadata is not available.");
                MapEntryMetaData mapEntryMetaData = RtElementHandler.getMapEntryMetaData(parentElement, qName);
                RtElementHandler.setMapEntryValue(mapEntryMetaData, parent, o);
            }
            return;
        }
        Object owner = parent;
        if (parent instanceof MapEntry && (owner = (mapEntry = (MapEntry)parent).getValue()) == null) {
            Class<?> valueCls;
            if (parentElement == null) {
                throw new JBossXBRuntimeException("Binding metadata needed for lazy map entry value instantiation is not available for parent element of element " + qName);
            }
            MapEntryMetaData mapEntryMetaData = RtElementHandler.getMapEntryMetaData(parentElement, qName);
            String valueType = mapEntryMetaData.getValueType();
            if (valueType == null) {
                throw new JBossXBRuntimeException("Element " + qName + " of type " + element.getType() + " is supposed to be bound as map entry value with lazy value instantiation " + "but value type is not specified in its map entry metadata.");
            }
            try {
                valueCls = Thread.currentThread().getContextClassLoader().loadClass(valueType);
            }
            catch (ClassNotFoundException e) {
                throw new JBossXBRuntimeException("Failed to load value type specified in the map entry metadata: " + valueType);
            }
            try {
                owner = valueCls.newInstance();
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to create an instance of value type " + valueType + ": " + e.getMessage());
            }
            RtElementHandler.setMapEntryValue(mapEntryMetaData, parent, owner);
        }
        if (element.getPutMethodMetaData() != null || element.getMapEntryMetaData() != null && owner instanceof Map) {
            this.invokePut(qName, element, owner, o);
            return;
        }
        if (element.getAddMethodMetaData() != null) {
            this.invokeAdd(qName, element, owner, o);
            return;
        }
        PropertyMetaData propertyMetaData = null;
        if (parentElement != null && parentElement.getType().hasWildcard()) {
            propertyMetaData = parentElement.getType().getWildcardPropertyMetaData();
        }
        if (propertyMetaData == null) {
            propertyMetaData = element.getPropertyMetaData();
        }
        if (owner instanceof GenericValueContainer) {
            ((GenericValueContainer)owner).addChild(qName, o);
            return;
        }
        if (owner instanceof ValueList) {
            ValueList valueList = (ValueList)owner;
            ValueListInitializer initializer = valueList.getInitializer();
            if (element.isMultiOccurs()) {
                Class<?> fieldType;
                String propName2;
                String string = propName2 = propertyMetaData == null ? null : propertyMetaData.getName();
                if (propName2 == null) {
                    propName2 = Util.xmlNameToFieldName(qName.getLocalPart(), element.getSchema().isIgnoreLowLine());
                }
                try {
                    fieldType = Classes.getAttributeGetter(valueList.getTargetClass(), propName2).getReturnType();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    String msg = "Neither getter/setter nor field were found for field " + propName2 + " in " + valueList.getTargetClass();
                    if (!element.getSchema().isIgnoreUnresolvedFieldOrClass()) throw new JBossXBRuntimeException(msg);
                    log.warn(msg);
                    return;
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    void var12_28;
                    Collection collection = (Collection)initializer.getElementValue(qName, valueList);
                    if (collection == null) {
                        void var12_27;
                        if ((fieldType.getModifiers() & 0x600) == 0) {
                            try {
                                Collection collection2 = (Collection)fieldType.newInstance();
                            }
                            catch (Exception e) {
                                throw new JBossXBRuntimeException("Failed to create an instance of " + fieldType + " for element " + qName);
                            }
                        } else if (Set.class.isAssignableFrom(fieldType)) {
                            HashSet hashSet = new HashSet();
                        } else {
                            ArrayList arrayList = new ArrayList();
                        }
                        initializer.addElementValue(qName, element, valueList, var12_27);
                    }
                    var12_28.add(o);
                    return;
                } else {
                    void var12_32;
                    if (!fieldType.isArray()) throw new JBossXBRuntimeException("Failed to recognize collection type of " + fieldType + " for element " + qName);
                    Object object = initializer.getElementValue(qName, valueList);
                    int index = 0;
                    if (object == null) {
                        Object object2 = Array.newInstance(fieldType.getComponentType(), 1);
                    } else {
                        Object tmp = object;
                        index = Array.getLength(object);
                        Object object3 = Array.newInstance(fieldType.getComponentType(), index + 1);
                        System.arraycopy(tmp, 0, object3, 0, index);
                    }
                    Array.set(var12_32, index, o);
                    initializer.addElementValue(qName, element, valueList, var12_32);
                }
                return;
            }
            initializer.addElementValue(qName, element, valueList, o);
            return;
        }
        if (propertyMetaData != null) {
            propName = propertyMetaData.getName();
            if (propName == null) {
                propName = Util.xmlNameToFieldName(qName.getLocalPart(), element.getSchema().isIgnoreLowLine());
            }
            RtUtil.set(owner, o, propName, propertyMetaData.getCollectionType(), element.getSchema().isIgnoreUnresolvedFieldOrClass(), element.getValueAdapter());
            return;
        } else if (owner instanceof Collection) {
            ((Collection)owner).add(o);
            return;
        } else {
            propName = Util.xmlNameToFieldName(qName.getLocalPart(), element.getSchema().isIgnoreLowLine());
            RtUtil.set(owner, o, propName, null, element.getSchema().isIgnoreUnresolvedFieldOrClass(), element.getValueAdapter());
        }
    }

    private static void setMapEntryValue(MapEntryMetaData mapEntryMetaData, Object parent, Object o) {
        String setValueMethodName;
        String getValueMethodName = mapEntryMetaData.getGetValueMethod();
        if (getValueMethodName == null) {
            getValueMethodName = "getValue";
        }
        if ((setValueMethodName = mapEntryMetaData.getSetValueMethod()) == null) {
            setValueMethodName = "setValue";
        }
        Class<?> parentCls = parent.getClass();
        Method setValueMethod = RtElementHandler.getSetMethod(parentCls, getValueMethodName, setValueMethodName);
        RtElementHandler.invokeSetter(setValueMethod, parent, o, setValueMethodName);
    }

    private static void invokeSetter(Method setValueMethod, Object parent, Object o, String setValueMethodName) {
        try {
            setValueMethod.invoke(parent, o);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("Failed to invoke " + setValueMethodName + " on " + parent + " with parameter " + o + ": " + e.getMessage());
        }
    }

    private static Method getSetMethod(Class cls, String getMethodName, String setMethodName) {
        Method setKeyMethod;
        Method getKeyMethod;
        try {
            getKeyMethod = cls.getMethod(getMethodName, null);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("Method " + getMethodName + " not found in " + cls);
        }
        try {
            setKeyMethod = cls.getMethod(setMethodName, getKeyMethod.getReturnType());
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("Method " + setMethodName + "(" + getKeyMethod.getReturnType().getName() + " p) not found in " + cls);
        }
        return setKeyMethod;
    }

    private static MapEntryMetaData getMapEntryMetaData(ElementBinding element, QName qName) {
        MapEntryMetaData mapEntryMetaData = element.getMapEntryMetaData();
        if (mapEntryMetaData == null) {
            throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key or value but map entry metadata is not available for its parent element nor its " + (element.getType().getQName() == null ? "annonymous" : element.getType().getQName().toString()) + " type.");
        }
        return mapEntryMetaData;
    }

    private static Object newInstance(Class cls, QName elementName, TypeBinding type) {
        Object o;
        block5: {
            try {
                if (cls.isArray()) {
                    o = GenericValueContainer.FACTORY.array(cls.getComponentType());
                    break block5;
                }
                Constructor ctor = cls.getConstructor(null);
                try {
                    o = ctor.newInstance(null);
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("Failed to create an instance of " + cls + " using default constructor for element " + elementName + " of type " + type.getQName() + ": " + e.getMessage(), e);
                }
            }
            catch (NoSuchMethodException e) {
                o = new ValueListInitializer().newValueList(ValueListHandler.IMMUTABLE, cls);
            }
        }
        return o;
    }

    private static Class getClass(String className, ElementBinding element, QName elementName) {
        TypeBinding type = element.getType();
        String localClassName = className;
        if (localClassName == null) {
            SchemaBinding schemaBinding;
            QName typeBaseQName = type.getQName();
            if (typeBaseQName == null) {
                typeBaseQName = elementName;
            }
            PackageMetaData jaxbPackage = (schemaBinding = type.getSchemaBinding()) == null ? null : schemaBinding.getPackageMetaData();
            String pkg = jaxbPackage == null ? Util.xmlNamespaceToJavaPackage(typeBaseQName.getNamespaceURI()) : jaxbPackage.getName();
            localClassName = Util.xmlNameToClassName(typeBaseQName.getLocalPart(), element.getSchema().isIgnoreLowLine());
            if (pkg != null && pkg.length() > 0) {
                localClassName = pkg + '.' + localClassName;
            }
        }
        Class<?> cls = null;
        try {
            cls = Thread.currentThread().getContextClassLoader().loadClass(localClassName);
        }
        catch (ClassNotFoundException e) {
            if (element.getSchema().isIgnoreUnresolvedFieldOrClass()) {
                if (log.isTraceEnabled()) {
                    log.trace("Failed to resolve class for element " + elementName + " of type " + type.getQName() + ": " + localClassName);
                }
            }
            throw new JBossXBRuntimeException("Failed to resolve class name for " + elementName + " of type " + type.getQName() + ": " + e.getMessage());
        }
        return cls;
    }

    private void invokeAdd(QName qName, ElementBinding element, Object owner, Object o) {
        Method addMethod;
        Class valueType;
        AddMethodMetaData addMethodMetaData = element.getAddMethodMetaData();
        Class clazz = valueType = Object.class;
        if (addMethodMetaData.getValueType() != null) {
            try {
                valueType = Thread.currentThread().getContextClassLoader().loadClass(addMethodMetaData.getValueType());
            }
            catch (ClassNotFoundException e) {
                throw new JBossXBRuntimeException("Failed to load value type for addMethod.name=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ": " + e.getMessage(), e);
            }
        } else if (addMethodMetaData.isChildType()) {
            if (o == null) {
                throw new JBossXBRuntimeException("addMethod=" + addMethodMetaData.getMethodName() + " for element " + qName + " is configured with valueType='child'. The valueType cannot be determined because" + " the child is null");
            }
            valueType = o.getClass();
        }
        Class<?> ownerClass = owner.getClass();
        try {
            addMethod = ownerClass.getMethod(addMethodMetaData.getMethodName(), valueType);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("Failed to find addMethod.name=" + addMethodMetaData.getMethodName() + ", addMethod.valueType=" + valueType.getName() + " in class " + ownerClass.getName() + ": " + e.getMessage(), e);
        }
        try {
            addMethod.invoke(owner, o);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": addMethod=" + addMethodMetaData.getMethodName() + " threw an exception for owner=" + owner + ", value=" + o + ": " + e.getMessage(), e);
        }
    }

    private void invokePut(QName qName, ElementBinding element, Object owner, Object o) {
        Method putMethod;
        Object key;
        Method keyMethod;
        PutMethodMetaData putMethodMetaData = element.getPutMethodMetaData();
        MapEntryMetaData mapEntryMetaData = element.getMapEntryMetaData();
        if (mapEntryMetaData == null) {
            throw new JBossXBRuntimeException((putMethodMetaData == null ? "Parent object is an instance of java.util.Map" : "putMethod is specified for element " + qName) + " but mapEntry is specified for neither element " + qName + " nor it's type " + element.getType().getQName());
        }
        Class<?> oClass = o.getClass();
        String getKeyMethodName = mapEntryMetaData.getGetKeyMethod();
        if (getKeyMethodName == null) {
            getKeyMethodName = "getKey";
        }
        try {
            keyMethod = oClass.getMethod(getKeyMethodName, null);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getKeyMethod=" + getKeyMethodName + " not found in " + oClass);
        }
        try {
            key = keyMethod.invoke(o, null);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getKeyMethod=" + getKeyMethodName + " threw an exception: " + e.getMessage(), e);
        }
        Class keyType = Object.class;
        Class valueType = Object.class;
        String putMethodName = "put";
        Class<?> ownerClass = owner.getClass();
        if (putMethodMetaData != null) {
            String name;
            if (putMethodMetaData.getKeyType() != null) {
                try {
                    keyType = Thread.currentThread().getContextClassLoader().loadClass(putMethodMetaData.getKeyType());
                }
                catch (ClassNotFoundException e) {
                    throw new JBossXBRuntimeException("setParent failed for " + qName + ": " + e.getMessage(), e);
                }
            }
            if (putMethodMetaData.getValueType() != null) {
                try {
                    valueType = Thread.currentThread().getContextClassLoader().loadClass(putMethodMetaData.getValueType());
                }
                catch (ClassNotFoundException e) {
                    throw new JBossXBRuntimeException("setParent failed for " + qName + ": " + e.getMessage(), e);
                }
            }
            if ((name = putMethodMetaData.getName()) != null) {
                putMethodName = name;
            }
        }
        try {
            putMethod = ownerClass.getMethod(putMethodName, keyType, valueType);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": putMethod=" + putMethodName + "(" + keyType.getName() + " key, " + valueType.getName() + " value) not found in " + ownerClass);
        }
        Object value = o;
        String valueMethodName = mapEntryMetaData.getGetValueMethod();
        if (valueMethodName != null) {
            Method valueMethod;
            try {
                valueMethod = oClass.getMethod(valueMethodName, null);
            }
            catch (NoSuchMethodException e) {
                throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getValueMethod=" + mapEntryMetaData.getGetValueMethod() + " not found in " + oClass);
            }
            try {
                value = valueMethod.invoke(o, null);
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getValueMethod=" + mapEntryMetaData.getGetValueMethod() + " threw an exception: " + e.getMessage(), e);
            }
        }
        if (o instanceof MapEntry) {
            value = ((MapEntry)o).getValue();
        }
        try {
            putMethod.invoke(owner, key, value);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": putMethod=" + putMethodName + " threw an exception for owner=" + owner + ", key=" + key + ", value=" + value + ": " + e.getMessage(), e);
        }
    }
}

