/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.filter;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import com.opensymphony.oscache.web.filter.CacheHttpServletResponseWrapper;
import com.opensymphony.oscache.web.filter.ExpiresRefreshPolicy;
import com.opensymphony.oscache.web.filter.ICacheGroupsProvider;
import com.opensymphony.oscache.web.filter.ICacheKeyProvider;
import com.opensymphony.oscache.web.filter.ResponseContent;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFilter
implements Filter,
ICacheKeyProvider,
ICacheGroupsProvider {
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final int FRAGMENT_AUTODETECT = -1;
    public static final int FRAGMENT_NO = 0;
    public static final int FRAGMENT_YES = 1;
    public static final int NOCACHE_OFF = 0;
    public static final int NOCACHE_SESSION_ID_IN_URL = 1;
    public static final long LAST_MODIFIED_OFF = 0L;
    public static final long LAST_MODIFIED_ON = 1L;
    public static final long LAST_MODIFIED_INITIAL = -1L;
    public static final long EXPIRES_OFF = 0L;
    public static final long EXPIRES_ON = 1L;
    public static final long EXPIRES_TIME = -1L;
    public static final long MAX_AGE_NO_INIT = Long.MIN_VALUE;
    public static final long MAX_AGE_TIME = Long.MAX_VALUE;
    private static final String REQUEST_FILTERED = "__oscache_filtered";
    private EntryRefreshPolicy expiresRefreshPolicy;
    private final Log log = LogFactory.getLog(this.getClass());
    private FilterConfig config;
    private ServletCacheAdministrator admin = null;
    private int cacheScope = 4;
    private int fragment = -1;
    private int time = 3600;
    private String cron = null;
    private int nocache = 0;
    private long lastModified = -1L;
    private long expires = 1L;
    private long cacheControlMaxAge = -60L;
    private ICacheKeyProvider cacheKeyProvider = this;
    private ICacheGroupsProvider cacheGroupsProvider = this;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("<cache>: filter in scope " + this.cacheScope));
        }
        if (this.isFilteredBefore(request) || !this.isCacheable(request)) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(REQUEST_FILTERED, (Object)Boolean.TRUE);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean fragmentRequest = this.isFragment(httpRequest);
        Cache cache = this.cacheScope == 3 ? this.admin.getSessionScopeCache(httpRequest.getSession(true)) : this.admin.getAppScopeCache(this.config.getServletContext());
        String key = this.cacheKeyProvider.createCacheKey(httpRequest, this.admin, cache);
        try {
            ResponseContent respContent = (ResponseContent)cache.getFromCache(key, this.time, this.cron);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("<cache>: Using cached entry for " + key));
            }
            boolean acceptsGZip = false;
            if (!fragmentRequest && this.lastModified != 0L) {
                long clientLastModified = httpRequest.getDateHeader(HEADER_IF_MODIFIED_SINCE);
                if (clientLastModified != -1L && clientLastModified >= respContent.getLastModified()) {
                    ((HttpServletResponse)response).setStatus(304);
                    return;
                }
                acceptsGZip = respContent.isContentGZiped() && this.acceptsGZipEncoding(httpRequest);
            }
            respContent.writeTo(response, fragmentRequest, acceptsGZip);
        }
        catch (NeedsRefreshException nre) {
            boolean updateSucceeded = false;
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("<cache>: New cache entry, cache stale or cache scope flushed for " + key));
                }
                CacheHttpServletResponseWrapper cacheResponse = new CacheHttpServletResponseWrapper((HttpServletResponse)response, fragmentRequest, (long)this.time * 1000L, this.lastModified, this.expires, this.cacheControlMaxAge);
                chain.doFilter(request, (ServletResponse)cacheResponse);
                cacheResponse.flushBuffer();
                if (this.isCacheable(cacheResponse)) {
                    String[] groups = this.cacheGroupsProvider.createCacheGroups(httpRequest, this.admin, cache);
                    cache.putInCache(key, cacheResponse.getContent(), groups, this.expiresRefreshPolicy, null);
                    updateSucceeded = true;
                }
            }
            finally {
                if (!updateSucceeded) {
                    cache.cancelUpdate(key);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        EntryRefreshPolicy expiresRefreshPolicy;
        ICacheGroupsProvider cacheGroupsProvider;
        this.config = filterConfig;
        this.admin = ServletCacheAdministrator.getInstance(this.config.getServletContext());
        try {
            this.time = Integer.parseInt(this.config.getInitParameter("time"));
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'time', defaulting to one hour.");
        }
        this.expiresRefreshPolicy = new ExpiresRefreshPolicy(this.time);
        try {
            String scopeString = this.config.getInitParameter("scope");
            if (scopeString.equals("session")) {
                this.cacheScope = 3;
            } else if (scopeString.equals("application")) {
                this.cacheScope = 4;
            } else if (scopeString.equals("request")) {
                this.cacheScope = 2;
            } else if (scopeString.equals("page")) {
                this.cacheScope = 1;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'scope', defaulting to 'application'.");
        }
        this.cron = this.config.getInitParameter("cron");
        try {
            String fragmentString = this.config.getInitParameter("fragment");
            if (fragmentString.equals("no")) {
                this.fragment = 0;
            } else if (fragmentString.equals("yes")) {
                this.fragment = 1;
            } else if (fragmentString.equalsIgnoreCase("auto")) {
                this.fragment = -1;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'fragment', defaulting to 'auto detect'.");
        }
        try {
            String nocacheString = this.config.getInitParameter("nocache");
            if (nocacheString.equals("off")) {
                this.nocache = 0;
            } else if (nocacheString.equalsIgnoreCase("sessionIdInURL")) {
                this.nocache = 1;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'nocache', defaulting to 'off'.");
        }
        try {
            String lastModifiedString = this.config.getInitParameter("lastModified");
            if (lastModifiedString.equals("off")) {
                this.lastModified = 0L;
            } else if (lastModifiedString.equals("on")) {
                this.lastModified = 1L;
            } else if (lastModifiedString.equalsIgnoreCase("initial")) {
                this.lastModified = -1L;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'lastModified', defaulting to 'initial'.");
        }
        try {
            String expiresString = this.config.getInitParameter("expires");
            if (expiresString.equals("off")) {
                this.expires = 0L;
            } else if (expiresString.equals("on")) {
                this.expires = 1L;
            } else if (expiresString.equalsIgnoreCase("time")) {
                this.expires = -1L;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'expires', defaulting to 'on'.");
        }
        try {
            String cacheControlMaxAgeString = this.config.getInitParameter("max-age");
            if (cacheControlMaxAgeString.equals("no init")) {
                this.cacheControlMaxAge = Long.MIN_VALUE;
            } else if (cacheControlMaxAgeString.equals("time")) {
                this.cacheControlMaxAge = Long.MAX_VALUE;
            } else {
                this.cacheControlMaxAge = Long.parseLong(cacheControlMaxAgeString);
                if (this.cacheControlMaxAge >= 0L) {
                    this.cacheControlMaxAge = -this.cacheControlMaxAge;
                } else {
                    this.log.warn((Object)"Init parameter 'max-age' must be at least a positive integer, defaulting to 'time'. ");
                    this.cacheControlMaxAge = 60L;
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)"Could not get init parameter 'max-age', defaulting to 'time'.");
        }
        ICacheKeyProvider cacheKeyProvider = (ICacheKeyProvider)this.instantiateFromInitParam("ICacheKeyProvider", ICacheKeyProvider.class, this.getClass().getName());
        if (cacheKeyProvider != null) {
            this.cacheKeyProvider = cacheKeyProvider;
        }
        if ((cacheGroupsProvider = (ICacheGroupsProvider)this.instantiateFromInitParam("ICacheGroupsProvider", ICacheGroupsProvider.class, this.getClass().getName())) != null) {
            this.cacheGroupsProvider = cacheGroupsProvider;
        }
        if ((expiresRefreshPolicy = (EntryRefreshPolicy)this.instantiateFromInitParam("EntryRefreshPolicy", EntryRefreshPolicy.class, this.expiresRefreshPolicy.getClass().getName())) != null) {
            this.expiresRefreshPolicy = expiresRefreshPolicy;
        }
    }

    private Object instantiateFromInitParam(String classInitParam, Class interfaceClass, String defaultClassName) {
        String className = this.config.getInitParameter(classInitParam);
        if (className == null) {
            this.log.info((Object)("Could not get init parameter '" + classInitParam + "', defaulting to " + defaultClassName + "."));
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (!interfaceClass.isAssignableFrom(clazz)) {
                this.log.error((Object)("Specified class '" + className + "' does not implement" + interfaceClass.getName() + ". Using default " + defaultClassName + "."));
                return null;
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Class '" + className + "' not found. Defaulting to " + defaultClassName + "."), (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error((Object)("Class '" + className + "' could not be instantiated because it is not a concrete class. Using default class " + defaultClassName + "."), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("Class '" + className + "' could not be instantiated because it is not public. Using default class " + defaultClassName + "."), (Throwable)e);
        }
        return null;
    }

    public String createCacheKey(HttpServletRequest httpRequest, ServletCacheAdministrator scAdmin, Cache cache) {
        return scAdmin.generateEntryKey(null, httpRequest, this.cacheScope);
    }

    public String[] createCacheGroups(HttpServletRequest httpRequest, ServletCacheAdministrator scAdmin, Cache cache) {
        return null;
    }

    protected boolean isFragment(HttpServletRequest request) {
        if (this.fragment == -1) {
            return request.getAttribute("javax.servlet.include.request_uri") != null;
        }
        return this.fragment != 0;
    }

    protected boolean isFilteredBefore(ServletRequest request) {
        return request.getAttribute(REQUEST_FILTERED) != null;
    }

    protected boolean isCacheable(ServletRequest request) {
        boolean cachable = request instanceof HttpServletRequest;
        if (cachable) {
            HttpServletRequest requestHttp = (HttpServletRequest)request;
            if (this.nocache == 1) {
                boolean bl = cachable = !requestHttp.isRequestedSessionIdFromURL();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("<cache>: the request " + (cachable ? "is" : "is not") + " cachable."));
        }
        return cachable;
    }

    protected boolean isCacheable(CacheHttpServletResponseWrapper cacheResponse) {
        boolean cachable;
        boolean bl = cachable = cacheResponse.getStatus() == 200;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("<cache>: the response " + (cachable ? "is" : "is not") + " cachable."));
        }
        return cachable;
    }

    protected boolean acceptsGZipEncoding(HttpServletRequest request) {
        String acceptEncoding = request.getHeader(HEADER_ACCEPT_ENCODING);
        return acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1;
    }
}

