/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.type;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.UserType;
import cirrus.hibernate.engine.Mapping;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.type.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CustomType
extends AbstractType {
    private final UserType userType;
    private final String name;
    private final int[] types;

    public CustomType(Class userTypeClass) throws MappingException {
        this.name = userTypeClass.getName();
        try {
            this.userType = (UserType)userTypeClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new MappingException("Cannot instantiate custom type: " + userTypeClass.getName());
        }
        catch (IllegalAccessException iae) {
            throw new MappingException("IllegalAccessException trying to instantiate custom type: " + userTypeClass.getName());
        }
        catch (ClassCastException cce) {
            throw new MappingException(userTypeClass.getName() + " must implement cirrus.hibernate.UserType");
        }
        this.types = this.userType.sqlTypes();
    }

    public int[] sqlTypes(Mapping pi) {
        return this.types;
    }

    public int getColumnSpan(Mapping session) {
        return this.types.length;
    }

    public Class returnedClass() {
        return this.userType.returnedClass();
    }

    public boolean equals(Object x, Object y) {
        return this.userType.equals(x, y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, names, owner);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.userType.nullSafeSet(st, value, index);
    }

    public String toXML(Object value, SessionFactoryImplementor factory) {
        return value.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object deepCopy(Object value) {
        return this.userType.deepCopy(value);
    }

    public boolean isMutable() {
        return this.userType.isMutable();
    }

    public boolean hasNiceEquals() {
        return false;
    }
}

