/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.transaction;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.NamingHelper;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.transaction.JTATransaction;
import cirrus.hibernate.transaction.TransactionFactory;
import cirrus.hibernate.transaction.TransactionManagerLookup;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTATransactionFactory
implements TransactionFactory {
    Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$transaction$JTATransactionFactory == null ? (class$cirrus$hibernate$transaction$JTATransactionFactory = JTATransactionFactory.class$("cirrus.hibernate.transaction.JTATransactionFactory")) : class$cirrus$hibernate$transaction$JTATransactionFactory));
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private InitialContext context;
    private String utName;
    private TransactionManager transactionManager;
    static /* synthetic */ Class class$cirrus$hibernate$transaction$JTATransactionFactory;

    public void configure(Properties props) throws HibernateException {
        try {
            this.context = NamingHelper.getInitialContext(props);
        }
        catch (NamingException ne) {
            this.log.error((Object)"Could not obtain initial context", (Throwable)ne);
            throw new HibernateException("Could not obtain initial context", ne);
        }
        this.utName = props.getProperty("jta.UserTransaction");
        String tmLookupClass = props.getProperty("hibernate.transaction.manager_lookup_class");
        if (tmLookupClass == null) {
            this.log.info((Object)"No TransactionManagerLookup configured (use of JCS read-write cache is not recommended)");
            this.transactionManager = null;
        } else {
            this.log.info((Object)("Locating TransactionManager using: " + tmLookupClass));
            try {
                TransactionManagerLookup tmlookup = (TransactionManagerLookup)ReflectHelper.classForName(tmLookupClass).newInstance();
                this.transactionManager = tmlookup.getTransactionManager(props);
                if (this.utName == null) {
                    this.utName = tmlookup.getUserTransactionName();
                }
                this.log.info((Object)"TransactionManager lookup successful");
            }
            catch (HibernateException he) {
                throw he;
            }
            catch (Exception e) {
                this.log.error((Object)"Could not instantiate TransactionManagerLookup", (Throwable)e);
                throw new HibernateException("Could not instantiate TransactionManagerLookup");
            }
        }
        if (this.utName == null) {
            this.utName = DEFAULT_USER_TRANSACTION_NAME;
        }
    }

    public Transaction beginTransaction(SessionImplementor session) throws HibernateException {
        return new JTATransaction(session, this.context, this.utName, this.transactionManager);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

