/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.updater;

import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.tools.updater.JdbcTableInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JdbcDatabaseInfo {
    private final Map _tables = new HashMap();
    private final Set _sequences = new HashSet();

    public JdbcDatabaseInfo(Connection connection, Dialect dialect) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        this.initTables(meta);
        this.initColumns(meta);
        this.initForeignKeys(meta);
        this.initIndexes(meta);
        this.initSequences(connection, dialect);
    }

    public JdbcTableInfo getTableInfo(String name) {
        return name != null ? (JdbcTableInfo)this._tables.get(name.toUpperCase()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initTables(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            String[] types = new String[]{"TABLE"};
            rs = meta.getTables(null, "%", "%", types);
            while (rs.next()) {
                this.addTable(rs);
            }
            Object var5_4 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    private void addTable(ResultSet rs) throws SQLException {
        String name = rs.getString("TABLE_NAME");
        if (name == null) {
            return;
        }
        if (this.getTableInfo(name) == null) {
            JdbcTableInfo info = new JdbcTableInfo(rs);
            this._tables.put(info.getName().toUpperCase(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initColumns(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getColumns(null, "%", "%", "%");
            while (rs.next()) {
                JdbcTableInfo info = this.getTableInfo(rs.getString("TABLE_NAME"));
                if (info == null) continue;
                info.addColumn(rs);
            }
            Object var5_4 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    private void initForeignKeys(DatabaseMetaData meta) throws SQLException {
        Iterator iterator = this._tables.values().iterator();
        while (iterator.hasNext()) {
            JdbcTableInfo info = (JdbcTableInfo)iterator.next();
            info.initForeignKeys(meta);
        }
    }

    private void initIndexes(DatabaseMetaData meta) throws SQLException {
        Iterator iterator = this._tables.values().iterator();
        while (iterator.hasNext()) {
            JdbcTableInfo info = (JdbcTableInfo)iterator.next();
            info.initIndexes(meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        String sql = dialect.getQuerySequencesString();
        if (sql == null) {
            return;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                this._sequences.add(rs.getString(1).toUpperCase());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public boolean isSequence(Object key) {
        return key instanceof String && this._sequences.contains(((String)key).toUpperCase());
    }
}

