/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.codegen;

import cirrus.hibernate.tools.codegen.ClassName;

public class Field {
    private String name = null;
    private String initialisation = null;
    private String asSuffix = null;
    private boolean id = false;
    private boolean generated = false;
    private boolean nullable = true;
    private ClassName classType;

    public Field(String name, ClassName type, boolean nullable) {
        this.name = name;
        this.setType(type);
        this.nullable = nullable;
        this.asSuffix = name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Field(String name, ClassName type, boolean nullable, boolean id, boolean generated) {
        this.name = name;
        this.setType(type);
        this.id = id;
        this.nullable = nullable;
        this.generated = generated;
        this.asSuffix = name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public Field(String name, ClassName type, String initialisation, boolean nullable) {
        this(name, type, nullable);
        this.initialisation = initialisation;
    }

    public String getInitialisation() {
        return this.initialisation;
    }

    public String getName() {
        return this.name;
    }

    public String getAsSuffix() {
        return this.asSuffix;
    }

    public String getType() {
        String type = this.classType.getFullyQualifiedName();
        int loc = type.indexOf("java.lang.");
        if (loc < 0) {
            return type;
        }
        return type.substring(10);
    }

    public boolean isIdentifier() {
        return this.id;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public String toString() {
        return this.getType() + ":" + this.getName();
    }

    public ClassName getClassType() {
        return this.classType;
    }

    private void setType(ClassName type) {
        this.classType = type;
    }
}

