/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.codegen;

import cirrus.hibernate.tools.codegen.ClassName;
import cirrus.hibernate.tools.codegen.Field;
import cirrus.hibernate.type.PrimitiveType;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jdom.Attribute;
import org.jdom.Element;

public class ClassMapping {
    private ClassName name = null;
    private String superClass = null;
    private ClassMapping superClassMapping = null;
    private String proxyClass = null;
    private List fields = new ArrayList();
    private TreeSet imports = new TreeSet();
    private List subclasses = new ArrayList();
    private static final Map components = new HashMap();
    private boolean mustImplementEquals = false;

    public ClassMapping(ClassName superClass, ClassMapping superClassMapping, Element classElement) throws Exception {
        this(superClass, classElement);
        this.superClassMapping = superClassMapping;
        if (this.superClassMapping != null) {
            List l = this.superClassMapping.getAllFieldsForFullConstructor();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                Field element = (Field)iter.next();
                ClassName ct = element.getClassType();
                if (ct != null) {
                    this.addImport(ct);
                    continue;
                }
                this.addImport(element.getType());
            }
        }
    }

    public ClassMapping(ClassName superClass, Element classElement) throws Exception {
        this(classElement);
        this.superClass = superClass.getName();
        this.addImport(superClass);
    }

    public ClassMapping(Element classElement) throws Exception {
        this(classElement, false);
    }

    public ClassMapping(Element classElement, boolean component) throws Exception {
        Element cmpid;
        Element id;
        String fullyQualifiedName = classElement.getAttributeValue(component ? "class" : "name");
        System.out.println("processing mapping for class: " + fullyQualifiedName);
        this.name = new ClassName();
        this.name.setFullyQualifiedName(fullyQualifiedName);
        ArrayList<Element> propertyList = new ArrayList<Element>();
        propertyList.addAll(classElement.getChildren("property"));
        propertyList.addAll(classElement.getChildren("version"));
        propertyList.addAll(classElement.getChildren("timestamp"));
        propertyList.addAll(classElement.getChildren("key-property"));
        ArrayList manyToOneList = new ArrayList();
        manyToOneList.addAll(classElement.getChildren("many-to-one"));
        manyToOneList.addAll(classElement.getChildren("key-many-to-one"));
        Attribute att = classElement.getAttribute("proxy");
        if (att != null) {
            this.proxyClass = att.getValue();
        }
        if ((id = classElement.getChild("id")) != null) {
            propertyList.add(0, id);
            this.implementEquals();
        }
        if ((cmpid = classElement.getChild("composite-id")) != null) {
            this.implementEquals();
            String cmpname = cmpid.getAttributeValue("name");
            String cmpclass = cmpid.getAttributeValue("class");
            if (cmpclass == null || cmpclass.equals("")) {
                propertyList.addAll(0, cmpid.getChildren("key-property"));
                manyToOneList.addAll(0, cmpid.getChildren("key-many-to-one"));
            } else {
                ClassMapping mapping = new ClassMapping(cmpid, true);
                mapping.implementEquals();
                ClassName classType = new ClassName();
                classType.setFullyQualifiedName(cmpclass);
                this.addImport(classType);
                this.fields.add(new Field(cmpname, classType, false, true, false));
                components.put(mapping.getCanonicalName(), mapping);
            }
        }
        Iterator properties = propertyList.iterator();
        while (properties.hasNext()) {
            Element column;
            Element property = (Element)properties.next();
            String name = property.getAttributeValue("name");
            if (name == null || name.trim().equals("")) continue;
            String type = property.getAttributeValue("type");
            if (type == null && cmpid != null) {
                type = property.getAttributeValue("class");
            }
            if (type == null || type.trim().equals("")) {
                System.out.println("property \"" + name + "\" in class " + this.getName() + " is missing a type attribute");
                continue;
            }
            if (property == id) {
                Element generator = property.getChild("generator");
                String unsavedValue = property.getAttributeValue("unsaved-value");
                boolean needObject = unsavedValue != null && unsavedValue.equals("null");
                boolean generated = !generator.getAttributeValue("class").equals("assigned");
                Field idField = new Field(name, this.getFieldType(type, needObject), false, true, generated);
                this.fields.add(idField);
                continue;
            }
            String notnull = property.getAttributeValue("not-null");
            if (notnull == null && (column = property.getChild("column")) != null) {
                notnull = column.getAttributeValue("not-null");
            }
            boolean nullable = notnull == null || notnull.equals("false");
            boolean key = property.getName().startsWith("key-");
            this.fields.add(new Field(name, this.getFieldType(type), nullable && !key, key, false));
        }
        List onetooneList = classElement.getChildren("one-to-one");
        Iterator onetoones = onetooneList.iterator();
        while (onetoones.hasNext()) {
            Element onetoone = (Element)onetoones.next();
            String name = onetoone.getAttributeValue("name");
            String clazz = onetoone.getAttributeValue("class");
            if (StringUtils.isEmpty((String)clazz)) {
                System.out.println("one-to-one \"" + name + "\" in class " + this.getName() + " is missing a class attribute");
                continue;
            }
            this.fields.add(new Field(name, this.getFieldType(clazz), true));
        }
        Iterator manytoOnes = manyToOneList.iterator();
        while (manytoOnes.hasNext()) {
            Element manyToOne = (Element)manytoOnes.next();
            String name = manyToOne.getAttributeValue("name");
            String type = manyToOne.getAttributeValue("class");
            if (StringUtils.isEmpty((String)type)) {
                System.out.println("many-to-one \"" + name + "\" in class " + this.getName() + " is missing a class attribute");
                continue;
            }
            ClassName classType = new ClassName();
            classType.setFullyQualifiedName(type);
            String notnull = manyToOne.getAttributeValue("not-null");
            boolean nullable = notnull == null || notnull.equals("false");
            boolean key = manyToOne.getName().startsWith("key-");
            this.addImport(classType);
            Field f = new Field(name, classType, nullable && !key, key, false);
            this.fields.add(f);
        }
        this.doCollections(classElement, "list", "java.util.List", "java.util.ArrayList");
        this.doCollections(classElement, "map", "java.util.Map", "java.util.HashMap");
        this.doCollections(classElement, "set", "java.util.Set", "java.util.HashSet");
        this.doCollections(classElement, "bag", "java.util.Collection", "java.util.ArrayList");
        this.doArrays(classElement, "array");
        this.doArrays(classElement, "primitive-array");
        Iterator iter = classElement.getChildren("component").iterator();
        while (iter.hasNext()) {
            Element cmpe = (Element)iter.next();
            String cmpname = cmpe.getAttributeValue("name");
            String cmpclass = cmpe.getAttributeValue("class");
            if (cmpclass == null || cmpclass.equals("")) {
                System.out.println("component \"" + cmpname + "\" in class " + this.getName() + " does not specify a class");
                continue;
            }
            ClassMapping mapping = new ClassMapping(cmpe, true);
            ClassName classType = new ClassName();
            classType.setFullyQualifiedName(cmpclass);
            this.addImport(classType);
            this.fields.add(new Field(cmpname, classType, false));
            components.put(mapping.getCanonicalName(), mapping);
        }
        Iterator iter2 = classElement.getChildren("subclass").iterator();
        while (iter2.hasNext()) {
            Element subclass = (Element)iter2.next();
            ClassMapping subclassMapping = new ClassMapping(this.name, this, subclass);
            this.subclasses.add(subclassMapping);
        }
        Iterator iter3 = classElement.getChildren("joined-subclass").iterator();
        while (iter3.hasNext()) {
            Element subclass = (Element)iter3.next();
            ClassMapping subclassMapping = new ClassMapping(this.name, this, subclass);
            this.subclasses.add(subclassMapping);
        }
    }

    public void implementEquals() {
        this.mustImplementEquals = true;
    }

    public boolean mustImplementEquals() {
        return this.mustImplementEquals;
    }

    public List getFields() {
        return this.fields;
    }

    public TreeSet getImports() {
        return this.imports;
    }

    public String getCanonicalName() {
        return this.name.getFullyQualifiedName();
    }

    public String getName() {
        return this.name.getName();
    }

    public String getProxy() {
        return this.proxyClass;
    }

    public String getPackageName() {
        return this.name.getPackageName();
    }

    public List getSubclasses() {
        return this.subclasses;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public boolean needsMinimalConstructor() {
        boolean generatedId = true;
        boolean missingId = true;
        int countNull = 0;
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Field f = (Field)it.next();
            if (f.isIdentifier()) {
                generatedId = f.isGenerated();
                missingId = false;
                continue;
            }
            if (!f.isNullable()) continue;
            ++countNull;
        }
        return !(countNull == 0 || countNull == this.fields.size() - 1 && generatedId || countNull == this.fields.size() && missingId);
    }

    public List getLocalFieldsForFullConstructor() {
        ArrayList<Field> result = new ArrayList<Field>();
        Iterator fields = this.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if (field.isIdentifier() && (!field.isIdentifier() || field.isGenerated())) continue;
            result.add(field);
        }
        return result;
    }

    public List getFieldsForSupersFullConstructor() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getFieldsForSupersFullConstructor());
            result.addAll(this.getSuperClassMapping().getLocalFieldsForFullConstructor());
        }
        return result;
    }

    public List getLocalFieldsForMinimalConstructor() {
        ArrayList<Field> result = new ArrayList<Field>();
        Iterator fields = this.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if ((field.isIdentifier() || field.isNullable()) && (!field.isIdentifier() || field.isGenerated())) continue;
            result.add(field);
        }
        return result;
    }

    public List getAllFieldsForFullConstructor() {
        List result = this.getFieldsForSupersFullConstructor();
        result.addAll(this.getLocalFieldsForFullConstructor());
        return result;
    }

    public List getFieldsForSupersMinimalConstructor() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getFieldsForSupersMinimalConstructor());
            result.addAll(this.getSuperClassMapping().getLocalFieldsForMinimalConstructor());
        }
        return result;
    }

    public List getAllFieldsForMinimalConstructor() {
        List result = this.getFieldsForSupersMinimalConstructor();
        result.addAll(this.getLocalFieldsForMinimalConstructor());
        return result;
    }

    private void addImport(ClassName className) {
        if (!(className.inJavaLang() || className.inSamePackage(this.name) || className.isPrimitive())) {
            if (className.isArray()) {
                this.imports.add(className.getFullyQualifiedName().substring(0, className.getFullyQualifiedName().length() - 2));
            } else {
                this.imports.add(className.getFullyQualifiedName());
            }
        }
    }

    private void addImport(String className) {
        ClassName cn = new ClassName();
        cn.setFullyQualifiedName(className);
        this.addImport(cn);
    }

    public static Iterator getComponents() {
        return components.values().iterator();
    }

    private void doCollections(Element classElement, String xmlName, String interfaceClass, String implementingClass) {
        ClassName interfaceClassName = new ClassName();
        ClassName implementingClassName = new ClassName();
        interfaceClassName.setFullyQualifiedName(interfaceClass);
        implementingClassName.setFullyQualifiedName(implementingClass);
        Iterator collections = classElement.getChildren(xmlName).iterator();
        while (collections.hasNext()) {
            Element collection = (Element)collections.next();
            String name = collection.getAttributeValue("role");
            this.addImport(interfaceClassName);
            this.fields.add(new Field(name, interfaceClassName, "new " + implementingClassName.getName() + "()", false));
            if (collection.getChildren("composite-element") == null) continue;
            Iterator compositeElements = collection.getChildren("composite-element").iterator();
            while (compositeElements.hasNext()) {
                Element compositeElement = (Element)compositeElements.next();
                String compClass = compositeElement.getAttributeValue("class");
                try {
                    ClassMapping mapping = new ClassMapping(compositeElement, true);
                    ClassName classType = new ClassName();
                    classType.setFullyQualifiedName(compClass);
                    this.addImport(classType);
                    components.put(mapping.getCanonicalName(), mapping);
                }
                catch (Exception e) {
                    System.err.println("Error building composite-element " + compClass);
                }
            }
        }
    }

    private void doArrays(Element classElement, String type) {
        Iterator arrays = classElement.getChildren(type).iterator();
        while (arrays.hasNext()) {
            Element array = (Element)arrays.next();
            String role = array.getAttributeValue("role");
            String elementClass = array.getAttributeValue("element-class");
            if (elementClass == null) {
                Element elt = array.getChild("element");
                if (elt == null) {
                    elt = array.getChild("one-to-many");
                }
                if (elt == null) {
                    elt = array.getChild("many-to-many");
                }
                if (elt == null) {
                    elt = array.getChild("composite-element");
                }
                if (elt == null) {
                    System.out.println("skipping collection with subcollections");
                    continue;
                }
                elementClass = elt.getAttributeValue("type");
                if (elementClass == null) {
                    elementClass = elt.getAttributeValue("class");
                }
            }
            ClassName cn = this.getFieldType(elementClass);
            cn.setFullyQualifiedName(cn.getFullyQualifiedName() + "[]", cn.isPrimitive());
            cn.setIsArray(true);
            this.fields.add(new Field(role, cn, false));
        }
    }

    private ClassName getFieldType(String hibernateType) {
        return this.getFieldType(hibernateType, false);
    }

    private ClassName getFieldType(String hibernateType, boolean needObject) {
        ClassName cn = new ClassName();
        if (hibernateType.equals("binary")) {
            cn.setFullyQualifiedName("byte[]", true);
            return cn;
        }
        Type basicType = TypeFactory.basic(hibernateType);
        if (basicType != null) {
            if (basicType instanceof PrimitiveType && !hibernateType.trim().equals(basicType.returnedClass().getName()) && !needObject) {
                cn.setFullyQualifiedName(((PrimitiveType)basicType).primitiveClass().getName(), true);
                return cn;
            }
            cn.setFullyQualifiedName(basicType.returnedClass().getName());
            return cn;
        }
        ClassName classType = new ClassName();
        classType.setFullyQualifiedName(hibernateType);
        this.addImport(classType);
        return classType;
    }

    public ClassMapping getSuperClassMapping() {
        return this.superClassMapping;
    }

    public void setSuperClassMapping(ClassMapping superClassMapping) {
        this.superClassMapping = superClassMapping;
    }
}

