/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.test;

import cirrus.hibernate.Hibernate;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.Session;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.sql.MySQLDialect;
import cirrus.hibernate.test.Child;
import cirrus.hibernate.test.Circular;
import cirrus.hibernate.test.Contained;
import cirrus.hibernate.test.Container;
import cirrus.hibernate.test.Many;
import cirrus.hibernate.test.One;
import cirrus.hibernate.test.Parent;
import cirrus.hibernate.test.Simple;
import cirrus.hibernate.test.TestCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ParentChildTest
extends TestCase {
    static /* synthetic */ Class class$cirrus$hibernate$test$Child;
    static /* synthetic */ Class class$cirrus$hibernate$test$Parent;
    static /* synthetic */ Class class$cirrus$hibernate$test$Container;
    static /* synthetic */ Class class$cirrus$hibernate$test$Contained;
    static /* synthetic */ Class class$cirrus$hibernate$test$Circular;
    static /* synthetic */ Class class$cirrus$hibernate$test$Foo;
    static /* synthetic */ Class class$cirrus$hibernate$test$Qux;
    static /* synthetic */ Class class$cirrus$hibernate$test$Bar;
    static /* synthetic */ Class class$cirrus$hibernate$test$Simple;
    static /* synthetic */ Class class$cirrus$hibernate$test$ParentChildTest;

    public ParentChildTest(String arg0) {
        super(arg0);
    }

    public void testCollectionQuery() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Simple s1 = new Simple();
        s1.setName("s");
        s1.setCount(0);
        Simple s2 = new Simple();
        s2.setCount(2);
        Simple s3 = new Simple();
        s3.setCount(3);
        s.save(s1, new Long(1L));
        s.save(s2, new Long(2L));
        s.save(s3, new Long(3L));
        Container c = new Container();
        ArrayList<Simple> l = new ArrayList<Simple>();
        l.add(s1);
        l.add(s3);
        l.add(s2);
        c.setOneToMany(l);
        l = new ArrayList();
        l.add(s1);
        l.add(null);
        l.add(s2);
        c.setManyToMany(l);
        s.save(c);
        Assert.assertTrue((s.find("select c from c in class Container, s in class Simple where c.oneToMany[2] = s").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container, s in class Simple where c.manyToMany[2] = s").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container, s in class Simple where s = c.oneToMany[2]").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container, s in class Simple where s = c.manyToMany[2]").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container where c.oneToMany[0].name = 's'").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container where c.manyToMany[0].name = 's'").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container where 's' = c.oneToMany[2 - 2].name").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container where 's' = c.manyToMany[(3+1)/4-1].name").size() == 1 ? 1 : 0) != 0);
        if (!(TestCase.dialect instanceof MySQLDialect)) {
            Assert.assertTrue((s.find("select c from c in class Container where c.manyToMany[ c.manyToMany.maxIndex ].count = 2").size() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((s.find("select c from c in class Container where c.oneToMany[ c.manyToMany[0].count ].name = 's'").size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("select c from c in class Container where c.manyToMany[ c.oneToMany[0].count ].name = 's'").size() == 1 ? 1 : 0) != 0);
        s.delete(c);
        s.delete(s1);
        s.delete(s2);
        s.delete(s3);
        t.commit();
        s.close();
    }

    public void testParentChild() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Parent p = new Parent();
        Child c = new Child();
        c.setParent(p);
        p.setChild(c);
        s.save(p);
        s.save(c);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Child)s.load(class$cirrus$hibernate$test$Child == null ? (class$cirrus$hibernate$test$Child = ParentChildTest.class$("cirrus.hibernate.test.Child")) : class$cirrus$hibernate$test$Child, (Serializable)new Long(c.getId()));
        p = c.getParent();
        this.assertTrue(p != null, "1-1 parent");
        c.setCount(32);
        p.setCount(66);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Child)s.load(class$cirrus$hibernate$test$Child == null ? (class$cirrus$hibernate$test$Child = ParentChildTest.class$("cirrus.hibernate.test.Child")) : class$cirrus$hibernate$test$Child, (Serializable)new Long(c.getId()));
        p = c.getParent();
        this.assertTrue(p.getCount() == 66, "1-1 update");
        this.assertTrue(c.getCount() == 32, "1-1 update");
        this.assertTrue(s.find("from c in class cirrus.hibernate.test.Child where c.parent.count=66").size() == 1, "1-1 query");
        s.find("select c, c.parent from c in class cirrus.hibernate.test.Child order by c.parent.count");
        s.find("select c, c.parent from c in class cirrus.hibernate.test.Child where c.parent.count=66 order by c.parent.count");
        s.iterate("select c, c.parent, c.parent.count from c in class cirrus.hibernate.test.Child order by c.parent.count");
        this.assertTrue(s.find("FROM p IN CLASS cirrus.hibernate.test.Parent WHERE p.count = ?", new Integer(66), Hibernate.INTEGER).size() == 1, "1-1 query");
        s.delete(c);
        s.delete(p);
        t.commit();
        s.close();
    }

    public void testParentNullChild() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Parent p = new Parent();
        s.save(p);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        p = (Parent)s.load(class$cirrus$hibernate$test$Parent == null ? (class$cirrus$hibernate$test$Parent = ParentChildTest.class$("cirrus.hibernate.test.Parent")) : class$cirrus$hibernate$test$Parent, (Serializable)new Long(p.getId()));
        Assert.assertTrue((p.getChild() == null ? 1 : 0) != 0);
        p.setCount(66);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        p = (Parent)s.load(class$cirrus$hibernate$test$Parent == null ? (class$cirrus$hibernate$test$Parent = ParentChildTest.class$("cirrus.hibernate.test.Parent")) : class$cirrus$hibernate$test$Parent, (Serializable)new Long(p.getId()));
        this.assertTrue(p.getCount() == 66, "null 1-1 update");
        Assert.assertTrue((p.getChild() == null ? 1 : 0) != 0);
        s.delete(p);
        t.commit();
        s.close();
    }

    public void testManyToMany() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Container c = new Container();
        c.setManyToMany(new ArrayList());
        c.setBag(new ArrayList());
        Simple s1 = new Simple();
        Simple s2 = new Simple();
        s1.setCount(123);
        s2.setCount(654);
        Contained c1 = new Contained();
        c1.setBag(new ArrayList());
        c1.getBag().add(c);
        c.getBag().add(c1);
        c.getManyToMany().add(s1);
        c.getManyToMany().add(s2);
        Serializable cid = s.save(c);
        s.save(s1, new Long(12L));
        s.save(s2, new Long(-1L));
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.load(class$cirrus$hibernate$test$Container == null ? (class$cirrus$hibernate$test$Container = ParentChildTest.class$("cirrus.hibernate.test.Container")) : class$cirrus$hibernate$test$Container, cid);
        Assert.assertTrue((c.getBag().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((c.getManyToMany().size() == 2 ? 1 : 0) != 0);
        c1 = (Contained)c.getBag().iterator().next();
        Assert.assertTrue((c.getBag().size() == 1 ? 1 : 0) != 0);
        c.getBag().remove(c1);
        c1.getBag().remove(c);
        Assert.assertTrue((c.getManyToMany().remove(0) != null ? 1 : 0) != 0);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.load(class$cirrus$hibernate$test$Container == null ? (class$cirrus$hibernate$test$Container = ParentChildTest.class$("cirrus.hibernate.test.Container")) : class$cirrus$hibernate$test$Container, cid);
        Assert.assertTrue((c.getBag().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.getManyToMany().size() == 1 ? 1 : 0) != 0);
        c1 = (Contained)s.load(class$cirrus$hibernate$test$Contained == null ? (class$cirrus$hibernate$test$Contained = ParentChildTest.class$("cirrus.hibernate.test.Contained")) : class$cirrus$hibernate$test$Contained, (Serializable)new Long(c1.getId()));
        Assert.assertTrue((c1.getBag().size() == 0 ? 1 : 0) != 0);
        s.delete("from c in class Container");
        s.delete("from c in class Contained");
        s.delete("from s in class Simple");
        t.commit();
        s.close();
    }

    public void testContainer() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Container c = new Container();
        Simple x = new Simple();
        x.setCount(123);
        Simple y = new Simple();
        y.setCount(456);
        s.save(x, new Long(1L));
        s.save(y, new Long(0L));
        ArrayList<Simple> o2m = new ArrayList<Simple>();
        o2m.add(x);
        o2m.add(null);
        o2m.add(y);
        ArrayList<Simple> m2m = new ArrayList<Simple>();
        m2m.add(x);
        m2m.add(null);
        m2m.add(y);
        c.setOneToMany(o2m);
        c.setManyToMany(m2m);
        ArrayList<Container.ContainerInnerClass> comps = new ArrayList<Container.ContainerInnerClass>();
        Container.ContainerInnerClass ccic = new Container.ContainerInnerClass();
        ccic.setName("foo");
        ccic.setSimple(x);
        comps.add(ccic);
        comps.add(null);
        ccic = new Container.ContainerInnerClass();
        ccic.setName("bar");
        ccic.setSimple(y);
        comps.add(ccic);
        HashSet<Container.ContainerInnerClass> compos = new HashSet<Container.ContainerInnerClass>();
        compos.add(ccic);
        c.setComposites(compos);
        c.setComponents(comps);
        One one = new One();
        Many many = new Many();
        HashSet<Many> manies = new HashSet<Many>();
        manies.add(many);
        one.setManies(manies);
        many.setOne(one);
        ccic.setMany(many);
        ccic.setOne(one);
        s.save(one);
        s.save(many);
        s.save(c);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.load(class$cirrus$hibernate$test$Container == null ? (class$cirrus$hibernate$test$Container = ParentChildTest.class$("cirrus.hibernate.test.Container")) : class$cirrus$hibernate$test$Container, (Serializable)new Long(c.getId()));
        System.out.println(c.getOneToMany());
        System.out.println(c.getManyToMany());
        System.out.println(c.getComponents());
        System.out.println(c.getComposites());
        ccic = (Container.ContainerInnerClass)c.getComponents().get(2);
        Assert.assertTrue((ccic.getMany().getOne() == ccic.getOne() ? 1 : 0) != 0);
        Assert.assertTrue((c.getComponents().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((c.getComposites().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((c.getManyToMany().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().get(0) != null ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().get(2) != null ? 1 : 0) != 0);
        int i = 0;
        while (i < 3) {
            Assert.assertTrue((c.getManyToMany().get(i) == c.getOneToMany().get(i) ? 1 : 0) != 0);
            ++i;
        }
        Object o1 = c.getOneToMany().get(0);
        Object o2 = c.getOneToMany().remove(2);
        c.getOneToMany().set(0, o2);
        c.getOneToMany().set(1, o1);
        o1 = c.getComponents().remove(2);
        c.getComponents().set(0, o1);
        c.getManyToMany().set(0, c.getManyToMany().get(2));
        c.getComposites().add(o1);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.load(class$cirrus$hibernate$test$Container == null ? (class$cirrus$hibernate$test$Container = ParentChildTest.class$("cirrus.hibernate.test.Container")) : class$cirrus$hibernate$test$Container, (Serializable)new Long(c.getId()));
        System.out.println(c.getOneToMany());
        System.out.println(c.getManyToMany());
        System.out.println(c.getComponents());
        System.out.println(c.getComposites());
        Assert.assertTrue((c.getComponents().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((c.getComposites().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((c.getManyToMany().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().get(0) != null ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().get(1) != null ? 1 : 0) != 0);
        ((Container.ContainerInnerClass)c.getComponents().get(0)).setName("a different name");
        ((Container.ContainerInnerClass)c.getComposites().iterator().next()).setName("once again");
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.load(class$cirrus$hibernate$test$Container == null ? (class$cirrus$hibernate$test$Container = ParentChildTest.class$("cirrus.hibernate.test.Container")) : class$cirrus$hibernate$test$Container, (Serializable)new Long(c.getId()));
        System.out.println(c.getOneToMany());
        System.out.println(c.getManyToMany());
        System.out.println(c.getComponents());
        System.out.println(c.getComposites());
        Assert.assertTrue((c.getComponents().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((c.getComposites().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Container.ContainerInnerClass)c.getComponents().get(0)).getName().equals("a different name"));
        Iterator iter = c.getComposites().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!((Container.ContainerInnerClass)iter.next()).getName().equals("once again")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        c.getOneToMany().clear();
        c.getManyToMany().clear();
        c.getComposites().clear();
        c.getComponents().clear();
        s.delete("from s in class Simple");
        s.delete("from m in class Many");
        s.delete("from o in class One");
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.load(class$cirrus$hibernate$test$Container == null ? (class$cirrus$hibernate$test$Container = ParentChildTest.class$("cirrus.hibernate.test.Container")) : class$cirrus$hibernate$test$Container, (Serializable)new Long(c.getId()));
        Assert.assertTrue((c.getComponents().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.getComposites().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.getOneToMany().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.getManyToMany().size() == 0 ? 1 : 0) != 0);
        s.delete(c);
        t.commit();
        s.close();
    }

    public void testBag() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Container c = new Container();
        Contained c1 = new Contained();
        Contained c2 = new Contained();
        c.setBag(new ArrayList());
        c.getBag().add(c1);
        c.getBag().add(c2);
        c1.getBag().add(c);
        c2.getBag().add(c);
        s.save(c);
        c.getBag().add(c2);
        c2.getBag().add(c);
        c.getLazyBag().add(c1);
        c1.getLazyBag().add(c);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.find("from c in class Container").get(0);
        Contained c3 = new Contained();
        c.getLazyBag().add(c3);
        c3.getLazyBag().add(c);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.find("from c in class Container").get(0);
        Contained c4 = new Contained();
        c.getLazyBag().add(c4);
        c4.getLazyBag().add(c);
        Assert.assertTrue((c.getLazyBag().size() == 3 ? 1 : 0) != 0);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        c = (Container)s.find("from c in class Container").get(0);
        Iterator i = c.getBag().iterator();
        int j = 0;
        while (i.hasNext()) {
            Assert.assertTrue((i.next() != null ? 1 : 0) != 0);
            ++j;
        }
        Assert.assertTrue((j == 3 ? 1 : 0) != 0);
        Assert.assertTrue((c.getLazyBag().size() == 3 ? 1 : 0) != 0);
        s.delete(c);
        c.getBag().remove(c2);
        Iterator iter = c.getBag().iterator();
        j = 0;
        while (iter.hasNext()) {
            ++j;
            s.delete(iter.next());
        }
        Assert.assertTrue((j == 2 ? 1 : 0) != 0);
        s.delete(s.load(class$cirrus$hibernate$test$Contained == null ? (class$cirrus$hibernate$test$Contained = ParentChildTest.class$("cirrus.hibernate.test.Contained")) : class$cirrus$hibernate$test$Contained, (Serializable)new Long(c4.getId())));
        s.delete(s.load(class$cirrus$hibernate$test$Contained == null ? (class$cirrus$hibernate$test$Contained = ParentChildTest.class$("cirrus.hibernate.test.Contained")) : class$cirrus$hibernate$test$Contained, (Serializable)new Long(c3.getId())));
        t.commit();
        s.close();
    }

    public void testCircularCascade() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction tx = s.beginTransaction();
        Circular c = new Circular();
        c.setClazz(class$cirrus$hibernate$test$Circular == null ? (class$cirrus$hibernate$test$Circular = ParentChildTest.class$("cirrus.hibernate.test.Circular")) : class$cirrus$hibernate$test$Circular);
        c.setOther(new Circular());
        c.getOther().setOther(new Circular());
        c.getOther().getOther().setOther(c);
        c.setAnyEntity(c.getOther());
        String id = (String)((Object)s.save(c));
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        c = (Circular)s.load(class$cirrus$hibernate$test$Circular == null ? (class$cirrus$hibernate$test$Circular = ParentChildTest.class$("cirrus.hibernate.test.Circular")) : class$cirrus$hibernate$test$Circular, (Serializable)((Object)id));
        c.getOther().getOther().setClazz(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = ParentChildTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo);
        tx.commit();
        s.close();
        c.getOther().setClazz(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = ParentChildTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux);
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        s.saveOrUpdate(c);
        tx.commit();
        s.close();
        c.getOther().getOther().setClazz(class$cirrus$hibernate$test$Bar == null ? (class$cirrus$hibernate$test$Bar = ParentChildTest.class$("cirrus.hibernate.test.Bar")) : class$cirrus$hibernate$test$Bar);
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        s.saveOrUpdate(c);
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        c = (Circular)s.load(class$cirrus$hibernate$test$Circular == null ? (class$cirrus$hibernate$test$Circular = ParentChildTest.class$("cirrus.hibernate.test.Circular")) : class$cirrus$hibernate$test$Circular, (Serializable)((Object)id));
        Assert.assertTrue((c.getOther().getOther().getClazz() == (class$cirrus$hibernate$test$Bar == null ? (class$cirrus$hibernate$test$Bar = ParentChildTest.class$("cirrus.hibernate.test.Bar")) : class$cirrus$hibernate$test$Bar) ? 1 : 0) != 0);
        Assert.assertTrue((c.getOther().getClazz() == (class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = ParentChildTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux) ? 1 : 0) != 0);
        Assert.assertTrue((c.getOther().getOther().getOther() == c ? 1 : 0) != 0);
        Assert.assertTrue((c.getAnyEntity() == c.getOther() ? 1 : 0) != 0);
        Assert.assertTrue((s.delete("from o in class java.lang.Object") == 3 ? 1 : 0) != 0);
        tx.commit();
        s.close();
    }

    public void testDeleteEmpty() throws Exception {
        Session s = TestCase.sessions.openSession();
        Assert.assertTrue((s.delete("from s in class Simple") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((s.delete("from o in class java.lang.Object") == 0 ? 1 : 0) != 0);
        s.close();
    }

    public void testLocking() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction tx = s.beginTransaction();
        Simple s1 = new Simple();
        s1.setCount(1);
        Simple s2 = new Simple();
        s2.setCount(2);
        Simple s3 = new Simple();
        s3.setCount(3);
        Simple s4 = new Simple();
        s4.setCount(4);
        s.save(s1, new Long(1L));
        s.save(s2, new Long(2L));
        s.save(s3, new Long(3L));
        s.save(s4, new Long(4L));
        Assert.assertTrue((s.getCurrentLockMode(s1) == LockMode.WRITE ? 1 : 0) != 0);
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        s1 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(1L), LockMode.NONE);
        Assert.assertTrue((s.getCurrentLockMode(s1) == LockMode.READ ? 1 : 0) != 0);
        s2 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(2L), LockMode.READ);
        Assert.assertTrue((s.getCurrentLockMode(s2) == LockMode.READ ? 1 : 0) != 0);
        s3 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(3L), LockMode.UPGRADE);
        Assert.assertTrue((s.getCurrentLockMode(s3) == LockMode.UPGRADE ? 1 : 0) != 0);
        s4 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(4L), LockMode.UPGRADE_NOWAIT);
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.UPGRADE_NOWAIT ? 1 : 0) != 0);
        s1 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(1L), LockMode.UPGRADE);
        Assert.assertTrue((s.getCurrentLockMode(s1) == LockMode.UPGRADE ? 1 : 0) != 0);
        s2 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(2L), LockMode.NONE);
        Assert.assertTrue((s.getCurrentLockMode(s2) == LockMode.READ ? 1 : 0) != 0);
        s3 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(3L), LockMode.READ);
        Assert.assertTrue((s.getCurrentLockMode(s3) == LockMode.UPGRADE ? 1 : 0) != 0);
        s4 = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = ParentChildTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(4L), LockMode.UPGRADE);
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.UPGRADE_NOWAIT ? 1 : 0) != 0);
        s.lock(s2, LockMode.UPGRADE);
        Assert.assertTrue((s.getCurrentLockMode(s2) == LockMode.UPGRADE ? 1 : 0) != 0);
        s.lock(s3, LockMode.UPGRADE);
        Assert.assertTrue((s.getCurrentLockMode(s3) == LockMode.UPGRADE ? 1 : 0) != 0);
        s.lock(s1, LockMode.UPGRADE_NOWAIT);
        s.lock(s4, LockMode.NONE);
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.UPGRADE_NOWAIT ? 1 : 0) != 0);
        tx.commit();
        tx = s.beginTransaction();
        Assert.assertTrue((s.getCurrentLockMode(s3) == LockMode.NONE ? 1 : 0) != 0);
        Assert.assertTrue((s.getCurrentLockMode(s1) == LockMode.NONE ? 1 : 0) != 0);
        Assert.assertTrue((s.getCurrentLockMode(s2) == LockMode.NONE ? 1 : 0) != 0);
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.NONE ? 1 : 0) != 0);
        s.lock(s1, LockMode.READ);
        Assert.assertTrue((s.getCurrentLockMode(s1) == LockMode.READ ? 1 : 0) != 0);
        s.lock(s2, LockMode.UPGRADE);
        Assert.assertTrue((s.getCurrentLockMode(s2) == LockMode.UPGRADE ? 1 : 0) != 0);
        s.lock(s3, LockMode.UPGRADE_NOWAIT);
        Assert.assertTrue((s.getCurrentLockMode(s3) == LockMode.UPGRADE_NOWAIT ? 1 : 0) != 0);
        s.lock(s4, LockMode.NONE);
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.NONE ? 1 : 0) != 0);
        s4.setName("s4");
        s.flush();
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.WRITE ? 1 : 0) != 0);
        tx.commit();
        tx = s.beginTransaction();
        Assert.assertTrue((s.getCurrentLockMode(s3) == LockMode.NONE ? 1 : 0) != 0);
        Assert.assertTrue((s.getCurrentLockMode(s1) == LockMode.NONE ? 1 : 0) != 0);
        Assert.assertTrue((s.getCurrentLockMode(s2) == LockMode.NONE ? 1 : 0) != 0);
        Assert.assertTrue((s.getCurrentLockMode(s4) == LockMode.NONE ? 1 : 0) != 0);
        s.delete(s1);
        s.delete(s2);
        s.delete(s3);
        s.delete(s4);
        tx.commit();
        s.close();
    }

    public static Test suite() throws Exception {
        try {
            TestCase.exportSchema(new String[]{"FooBar.hbm.xml", "Baz.hbm.xml", "Qux.hbm.xml", "Glarch.hbm.xml", "Fum.hbm.xml", "Fumm.hbm.xml", "Fo.hbm.xml", "One.hbm.xml", "Many.hbm.xml", "Immutable.hbm.xml", "Fee.hbm.xml", "Vetoer.hbm.xml", "Holder.hbm.xml", "ParentChild.hbm.xml", "Simple.hbm.xml", "Container.hbm.xml", "Circular.hbm.xml", "Stuff.hbm.xml"});
            return new TestSuite(class$cirrus$hibernate$test$ParentChildTest == null ? (class$cirrus$hibernate$test$ParentChildTest = ParentChildTest.class$("cirrus.hibernate.test.ParentChildTest")) : class$cirrus$hibernate$test$ParentChildTest);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

