/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.loader;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.loader.CollectionInitializer;
import cirrus.hibernate.loader.Loader;
import cirrus.hibernate.loader.OuterJoinLoader;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;

public class OneToManyLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final CollectionPersister collectionPersister;
    private final Type[] idType;
    private final boolean allowTwoPhaseLoad;

    public OneToManyLoader(CollectionPersister collPersister, SessionFactoryImplementor session) throws MappingException {
        super(session.getDialect());
        this.allowTwoPhaseLoad = !collPersister.isSet();
        this.collectionPersister = collPersister;
        this.idType = new Type[]{collPersister.getKeyType()};
        Loadable persister = (Loadable)session.getPersister(((EntityType)collPersister.getElementType()).getPersistentClass());
        String alias = OuterJoinLoader.alias(this.collectionPersister.getQualifiedTableName(), 0);
        String collAlias = persister.getConcreteClassAlias(alias);
        List associations = this.walkTree(persister, alias, session);
        int joins = associations.size();
        this.suffixes = new String[joins + 1];
        int i = 0;
        while (i <= joins) {
            this.suffixes[i] = joins == 0 ? "" : Integer.toString(i);
            ++i;
        }
        this.sql = Loader.sqlSelect(OuterJoinLoader.selectCollectionString(collPersister, collAlias) + (joins == 0 ? "" : ", " + this.selectString(associations)) + ", " + OuterJoinLoader.selectString(persister, alias, this.suffixes[joins]), persister.fromClauseFragment(alias, true), this.outerJoinGenerator.outerJoinStringAfterFrom(associations), OuterJoinLoader.whereString(collPersister.getKeyColumnNames(), collAlias), this.outerJoinGenerator.outerJoinStringAfterWhere(associations) + persister.outerJoinsAfterWhere(alias, true), collPersister.hasOrdering() ? collPersister.getSQLOrderByString(collAlias) : null);
        this.classPersisters = new Loadable[joins + 1];
        int i2 = 0;
        while (i2 < joins) {
            this.classPersisters[i2] = ((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i2)).subpersister;
            ++i2;
        }
        this.classPersisters[joins] = persister;
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, PersistentCollection collection, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, new Object[]{id}, this.idType, collection, true);
    }

    protected boolean allowTwoPhaseLoad() {
        return this.allowTwoPhaseLoad;
    }
}

