/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.SessionFactory;
import cirrus.hibernate.helpers.FastHashMap;
import cirrus.hibernate.helpers.NamingHelper;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionFactoryObjectFactory
implements ObjectFactory {
    private static final SessionFactoryObjectFactory INSTANCE;
    private static final Log log;
    private static final FastHashMap instances;
    private static final FastHashMap namedInstances;
    private static final NamingListener listener;
    static /* synthetic */ Class class$cirrus$hibernate$impl$SessionFactoryObjectFactory;

    public Object getObjectInstance(Object reference, Name name, Context ctx, Hashtable env) throws Exception {
        log.debug((Object)("JNDI lookup: " + name));
        String uid = (String)((Reference)reference).get(0).getContent();
        return SessionFactoryObjectFactory.getInstance(uid);
    }

    public static void addInstance(String uid, String name, SessionFactory instance, Properties properties) {
        log.debug((Object)("registered: " + uid + " (" + (name == null ? "unnamed" : name) + ')'));
        instances.put(uid, instance);
        if (name != null) {
            namedInstances.put(name, instance);
        }
        if (name == null) {
            log.info((Object)"no JDNI name configured");
        } else {
            log.info((Object)("Factory name: " + name));
            try {
                InitialContext ctx = NamingHelper.getInitialContext(properties);
                NamingHelper.bind(ctx, name, instance);
                log.info((Object)("Bound factory to JNDI name: " + name));
                ((EventContext)((Object)ctx)).addNamingListener(name, 0, listener);
            }
            catch (InvalidNameException ine) {
                log.error((Object)("Invalid JNDI name: " + name), (Throwable)ine);
            }
            catch (NamingException ne) {
                log.warn((Object)"Could not bind factory to JNDI", (Throwable)ne);
            }
            catch (ClassCastException cce) {
                log.warn((Object)"InitialContext did not implement EventContext");
            }
        }
    }

    public static Object getNamedInstance(String name) {
        log.debug((Object)("lookup: name=" + name));
        Object result = namedInstances.get(name);
        if (result == null) {
            log.warn((Object)("Not found: " + name));
            log.debug((Object)namedInstances);
        }
        return result;
    }

    public static Object getInstance(String uid) {
        log.debug((Object)("lookup: uid=" + uid));
        Object result = instances.get(uid);
        if (result == null) {
            log.warn((Object)("Not found: " + uid));
            log.debug((Object)instances);
        }
        return result;
    }

    public static void clear() {
        instances.clear();
        namedInstances.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$SessionFactoryObjectFactory == null ? (class$cirrus$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryObjectFactory.class$("cirrus.hibernate.impl.SessionFactoryObjectFactory")) : class$cirrus$hibernate$impl$SessionFactoryObjectFactory));
        INSTANCE = new SessionFactoryObjectFactory();
        log.debug((Object)"initializing class SessionFactoryObjectFactory");
        instances = new FastHashMap();
        namedInstances = new FastHashMap();
        listener = new NamespaceChangeListener(){

            public void objectAdded(NamingEvent evt) {
                log.debug((Object)("A factory was successfully bound to name: " + evt.getNewBinding().getName()));
            }

            public void objectRemoved(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                log.info((Object)("A factory was unbound from name: " + name));
                Object instance = namedInstances.remove(name);
                Iterator iter = instances.values().iterator();
                while (iter.hasNext()) {
                    if (iter.next() != instance) continue;
                    iter.remove();
                }
            }

            public void objectRenamed(NamingEvent evt) {
                String name = evt.getOldBinding().getName();
                log.info((Object)("A factory was renamed from name: " + name));
                namedInstances.put(evt.getNewBinding().getName(), namedInstances.remove(name));
            }

            public void namingExceptionThrown(NamingExceptionEvent evt) {
                log.warn((Object)("Naming exception occurred accessing factory: " + evt.getException()));
            }
        };
    }
}

