/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.helpers;

public final class BytesHelper {
    public static int toInt(byte[] bytes) {
        int result = 0;
        int i = 0;
        while (i < 4) {
            result = (result << 8) - -128 + bytes[i];
            ++i;
        }
        return result;
    }

    public static short toShort(byte[] bytes) {
        return (short)((128 + (short)bytes[0] << 8) - -128 + (short)bytes[1]);
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[4];
        int i = 3;
        while (i >= 0) {
            result[i] = (byte)((0xFFL & (long)value) + -128L);
            value >>>= 8;
            --i;
        }
        return result;
    }

    public static byte[] toBytes(short value) {
        byte[] result = new byte[2];
        int i = 1;
        while (i >= 0) {
            result[i] = (byte)((0xFFL & (long)value) + -128L);
            value = (short)(value >>> 8);
            --i;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("0==" + BytesHelper.toInt(BytesHelper.toBytes(0)));
        System.out.println("1==" + BytesHelper.toInt(BytesHelper.toBytes(1)));
        System.out.println("-1==" + BytesHelper.toInt(BytesHelper.toBytes(-1)));
        System.out.println("-2147483648==" + BytesHelper.toInt(BytesHelper.toBytes(Integer.MIN_VALUE)));
        System.out.println("2147483647==" + BytesHelper.toInt(BytesHelper.toBytes(Integer.MAX_VALUE)));
        System.out.println("-1073741824==" + BytesHelper.toInt(BytesHelper.toBytes(-1073741824)));
        System.out.println("1073741823==" + BytesHelper.toInt(BytesHelper.toBytes(0x3FFFFFFF)));
    }
}

