/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.connection;

import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.C3P0ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.DBCPConnectionProvider;
import cirrus.hibernate.connection.DatasourceConnectionProvider;
import cirrus.hibernate.connection.DriverManagerConnectionProvider;
import cirrus.hibernate.connection.UserSuppliedConnectionProvider;
import cirrus.hibernate.helpers.ReflectHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionProviderFactory {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$connection$ConnectionProviderFactory == null ? (class$cirrus$hibernate$connection$ConnectionProviderFactory = ConnectionProviderFactory.class$("cirrus.hibernate.connection.ConnectionProviderFactory")) : class$cirrus$hibernate$connection$ConnectionProviderFactory));
    static /* synthetic */ Class class$cirrus$hibernate$connection$ConnectionProviderFactory;

    public static ConnectionProvider newConnectionProvider() throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(Environment.getProperties());
    }

    public static ConnectionProvider newConnectionProvider(Properties properties) throws HibernateException {
        ConnectionProvider connections;
        String providerClass = properties.getProperty("hibernate.connection.provider_class");
        if (providerClass != null) {
            try {
                log.info((Object)("Initializing connection provider: " + providerClass));
                connections = (ConnectionProvider)ReflectHelper.classForName(providerClass).newInstance();
            }
            catch (Exception e) {
                log.fatal((Object)"Could not instantiate connection provider", (Throwable)e);
                throw new HibernateException("Could not instantiate connection provider: " + providerClass);
            }
        } else {
            connections = properties.getProperty("hibernate.connection.datasource") != null ? new DatasourceConnectionProvider() : (properties.getProperty("hibernate.c3p0.max_size") != null ? new C3P0ConnectionProvider() : (properties.getProperty("hibernate.dbcp.maxIdle") != null ? new DBCPConnectionProvider() : (properties.getProperty("hibernate.connection.url") != null ? new DriverManagerConnectionProvider() : new UserSuppliedConnectionProvider())));
        }
        connections.configure(properties);
        return connections;
    }

    private ConnectionProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static Properties getJdbcConnectionProperties(Properties properties) {
        HashSet<String> specialProps = new HashSet<String>();
        specialProps.add("hibernate.connection.datasource");
        specialProps.add("hibernate.connection.url");
        specialProps.add("hibernate.connection.provider_class");
        specialProps.add("hibernate.connection.pool_size");
        specialProps.add("hibernate.connection.isolation");
        specialProps.add("hibernate.connection.driver_class");
        specialProps.add("hibernate.connection.username");
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("hibernate.connection") <= -1 || specialProps.contains(prop)) continue;
            result.setProperty(prop.substring("hibernate.connection".length() + 1), properties.getProperty(prop));
        }
        result.setProperty("user", properties.getProperty("hibernate.connection.username"));
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

