/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.collections;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.ODMGCollection;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.LinkedHashCollectionHelper;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.odmg.DSet;

public class Set
extends ODMGCollection
implements java.util.Set,
DSet {
    protected java.util.Set set;

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        HashSet<Object> clonedSet = new HashSet<Object>(this.set.size());
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            clonedSet.add(persister.getElementType().deepCopy(iter.next()));
        }
        return clonedSet;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        java.util.Set sn = (java.util.Set)((Object)this.getSnapshot());
        if (sn.size() != this.set.size()) {
            return false;
        }
        if (elementType.hasNiceEquals()) {
            return sn.equals(this.set);
        }
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object test = iter.next();
            Iterator sniter = sn.iterator();
            boolean success = false;
            while (sniter.hasNext()) {
                if (!elementType.equals(test, sniter.next())) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    public Set(SessionImplementor session) {
        super(session);
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.set = persister.hasOrdering() ? LinkedHashCollectionHelper.createLinkedHashSet() : new HashSet();
    }

    public Set(SessionImplementor session, java.util.Set set) {
        super(session);
        this.set = set;
        this.initialized = true;
    }

    public void replaceElements(Map replacements) throws HibernateException {
        Iterator iter = replacements.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            if (!this.set.remove(e.getKey())) {
                throw new HibernateException("Application error: the hashcode of a mutable element of a set changed");
            }
            this.set.add(e.getValue());
        }
    }

    public Iterator elements() {
        return this.set.iterator();
    }

    public boolean empty() {
        return this.set.isEmpty();
    }

    public int size() {
        this.read();
        return this.set.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.set.isEmpty();
    }

    public boolean contains(Object arg0) {
        this.read();
        return this.set.contains(arg0);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this.set.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.set.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        this.read();
        return this.set.toArray(arg0);
    }

    public boolean add(Object arg0) {
        this.write();
        return this.set.add(arg0);
    }

    public boolean remove(Object arg0) {
        this.write();
        return this.set.remove(arg0);
    }

    public boolean containsAll(Collection arg0) {
        this.read();
        return this.set.containsAll(arg0);
    }

    public boolean addAll(Collection arg0) {
        this.write();
        return this.set.addAll(arg0);
    }

    public boolean retainAll(Collection arg0) {
        this.write();
        return this.set.retainAll(arg0);
    }

    public boolean removeAll(Collection arg0) {
        this.write();
        return this.set.remove(arg0);
    }

    public void clear() {
        this.write();
        this.set.clear();
    }

    public String toString() {
        this.read();
        return this.set.toString();
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, this.session);
        this.set.add(element);
        return element;
    }

    public Iterator entries() {
        return this.set.iterator();
    }

    public void readEntries(Iterator entries) {
        while (entries.hasNext()) {
            this.set.add(entries.next());
        }
    }

    public void assemble(CollectionPersister persister) throws HibernateException, SQLException {
        java.util.Set old = this.set;
        this.beforeInitialize(persister);
        Iterator iter = old.iterator();
        while (iter.hasNext()) {
            this.set.add(persister.getElementType().assemble((Serializable)iter.next(), this.session, null));
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        HashSet<Serializable> result = new HashSet<Serializable>();
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            result.add(persister.getElementType().disassemble(iter.next(), this.session));
        }
        return result;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        java.util.Set sn = (java.util.Set)((Object)this.getSnapshot());
        ArrayList deletes = new ArrayList(sn.size());
        Iterator iter = sn.iterator();
        while (iter.hasNext()) {
            Object test = iter.next();
            if (!this.set.contains(test)) {
                deletes.add(test);
                continue;
            }
            if (elemType.hasNiceEquals()) continue;
            Iterator setiter = this.set.iterator();
            boolean found = false;
            while (setiter.hasNext()) {
                if (!elemType.equals(setiter.next(), test)) continue;
                found = true;
                break;
            }
            if (found) continue;
            deletes.add(test);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        java.util.Set sn = (java.util.Set)((Object)this.getSnapshot());
        if (!sn.contains(entry)) {
            return true;
        }
        if (!elemType.hasNiceEquals()) {
            Iterator iter = sn.iterator();
            while (iter.hasNext()) {
                if (!elemType.equals(iter.next(), entry)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        return false;
    }

    public Object getIndex(Object entry, int i) {
        throw new UnsupportedOperationException("Sets don't have indexes");
    }

    public Set() {
    }

    public DSet union(DSet set) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.addAll(set);
        return new Set(this.session, newset);
    }

    public DSet difference(DSet set) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.removeAll((Collection<?>)set);
        return new Set(this.session, newset);
    }

    public DSet intersection(DSet set) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.retainAll((Collection<?>)set);
        return new Set(this.session, newset);
    }

    public boolean properSubsetOf(DSet set) {
        this.read();
        return set.size() > this.set.size() && set.containsAll((Collection)this.set);
    }

    public boolean properSupersetOf(DSet set) {
        this.read();
        return this.set.size() > set.size() && this.set.containsAll((Collection<?>)set);
    }

    public boolean subsetOf(DSet set) {
        this.read();
        return set.size() >= this.set.size() && set.containsAll((Collection)this.set);
    }

    public boolean supersetOf(DSet set) {
        this.read();
        return this.set.size() >= set.size() && this.set.containsAll((Collection<?>)set);
    }
}

