/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.util.ArrayList;
import org.apache.commons.jci.problems.CompilationProblem;

public final class CompilationResult {
    private final CompilationProblem[] errors;
    private final CompilationProblem[] warnings;

    public CompilationResult(CompilationProblem[] pProblems) {
        ArrayList<CompilationProblem> errorsColl = new ArrayList<CompilationProblem>();
        ArrayList<CompilationProblem> warningsColl = new ArrayList<CompilationProblem>();
        for (int i = 0; i < pProblems.length; ++i) {
            CompilationProblem problem = pProblems[i];
            if (problem.isError()) {
                errorsColl.add(problem);
                continue;
            }
            warningsColl.add(problem);
        }
        this.errors = new CompilationProblem[errorsColl.size()];
        errorsColl.toArray(this.errors);
        this.warnings = new CompilationProblem[warningsColl.size()];
        warningsColl.toArray(this.warnings);
    }

    public CompilationProblem[] getErrors() {
        return this.errors;
    }

    public CompilationProblem[] getWarnings() {
        return this.warnings;
    }
}

