/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.AntClassLoader;
import xdoclet.loader.ModuleFinder;
import xdoclet.loader.XDocletModule;
import xdoclet.loader.XDocletXmlParser;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;

public class ModuleFinder {
    private static final FileFilter jarFilter = new 1();
    private static String classpath;
    private static List modules;
    static /* synthetic */ Class class$xdoclet$loader$ModuleFinder;
    static /* synthetic */ Class class$xdoclet$loader$LoaderMessages;

    public static String getClasspath() {
        return classpath;
    }

    public static File getNewestFileOnClassPath() {
        List moduleFiles = ModuleFinder.findModuleFiles();
        long newest = Long.MIN_VALUE;
        File newestFile = null;
        Iterator i = moduleFiles.iterator();
        while (i.hasNext()) {
            File moduleFile = (File)i.next();
            if (moduleFile.lastModified() < newest) continue;
            newestFile = moduleFile;
            newest = moduleFile.lastModified();
        }
        return newestFile;
    }

    public static void setClasspath(String classpath) {
        ModuleFinder.classpath = classpath;
    }

    public static void initClasspath(Class clazz) {
        if (System.getProperty("xdoclet.class.path") == null) {
            try {
                classpath = ((AntClassLoader)clazz.getClassLoader()).getClasspath();
            }
            catch (ClassCastException e) {
                classpath = System.getProperty("java.class.path");
            }
        } else {
            classpath = System.getProperty("xdoclet.class.path");
        }
    }

    public static List findModules() {
        if (modules == null) {
            modules = new ArrayList();
            Class clazz = class$xdoclet$loader$ModuleFinder;
            if (clazz == null) {
                clazz = class$xdoclet$loader$ModuleFinder = ModuleFinder.class$("[Lxdoclet.loader.ModuleFinder;", false);
            }
            Log log = LogUtil.getLog(clazz, "findModules");
            Class clazz2 = class$xdoclet$loader$LoaderMessages;
            if (clazz2 == null) {
                clazz2 = class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
            }
            log.debug((Object)Translator.getString(clazz2, "REGISTERING_MODULES"));
            XDocletXmlParser parser = new XDocletXmlParser();
            List moduleFiles = ModuleFinder.findModuleFiles();
            Iterator moduleFileIterator = moduleFiles.iterator();
            while (moduleFileIterator.hasNext()) {
                File file = (File)moduleFileIterator.next();
                if (file.exists()) {
                    try {
                        InputStream xdocletXmlIs = null;
                        URL xtagsURL = null;
                        if (file.isDirectory()) {
                            xdocletXmlIs = new FileInputStream(new File(file, "META-INF" + File.separator + "xdoclet.xml"));
                            xtagsURL = new File(file, "META-INF" + File.separator + "xtags.xml").toURL();
                        } else {
                            JarFile jar = new JarFile(file);
                            JarEntry xdocletXml = jar.getJarEntry("META-INF/xdoclet.xml");
                            xtagsURL = new URL(new URL("jar:" + file.toURL() + "!/"), "META-INF/xtags.xml");
                            if (xdocletXml != null) {
                                Class clazz3 = class$xdoclet$loader$LoaderMessages;
                                if (clazz3 == null) {
                                    clazz3 = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
                                }
                                log.debug((Object)Translator.getString(clazz3, "PARSING_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                                xdocletXmlIs = jar.getInputStream(xdocletXml);
                            } else {
                                Class clazz4 = class$xdoclet$loader$LoaderMessages;
                                if (clazz4 == null) {
                                    clazz4 = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
                                }
                                log.debug((Object)Translator.getString(clazz4, "SKIP_NO_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                            }
                        }
                        if (xdocletXmlIs == null) continue;
                        XDocletModule module = parser.parse(xdocletXmlIs);
                        if (module != null) {
                            module.setXTagsDefinitionURL(xtagsURL);
                            modules.add(module);
                            continue;
                        }
                        Class clazz5 = class$xdoclet$loader$LoaderMessages;
                        if (clazz5 == null) {
                            clazz5 = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
                        }
                        log.warn((Object)Translator.getString(clazz5, "BAD_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                        continue;
                    }
                    catch (IOException e) {
                        Class clazz6 = class$xdoclet$loader$LoaderMessages;
                        if (clazz6 == null) {
                            clazz6 = class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
                        }
                        throw new IllegalStateException(Translator.getString(clazz6, "LOAD_MODULE_ERROR", new String[]{e.getMessage()}));
                    }
                }
                Class clazz7 = class$xdoclet$loader$LoaderMessages;
                if (clazz7 == null) {
                    clazz7 = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
                }
                log.warn((Object)Translator.getString(clazz7, "NONEXISTANT_CLASSPATH_ENTRY", new String[]{file.getAbsolutePath()}));
            }
            Class clazz8 = class$xdoclet$loader$LoaderMessages;
            if (clazz8 == null) {
                clazz8 = class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
            }
            log.debug((Object)Translator.getString(clazz8, "DONE_REGISTERING_MODULES", new String[]{String.valueOf(modules.size())}));
        }
        return modules;
    }

    public static void resetFoundModules() {
        modules = null;
    }

    private static final List findModuleFiles() {
        if (classpath == null) {
            Class clazz = class$xdoclet$loader$LoaderMessages;
            if (clazz == null) {
                clazz = class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("[Lxdoclet.loader.LoaderMessages;", false);
            }
            throw new IllegalStateException(Translator.getString(clazz, "INIT_CLASSPATH_NOT_CALLED"));
        }
        ArrayList<File> result = new ArrayList<File>();
        StringTokenizer pathTokenizer = new StringTokenizer(classpath, System.getProperty("path.separator"));
        while (pathTokenizer.hasMoreTokens()) {
            File file = new File(pathTokenizer.nextToken());
            if (file.isDirectory()) {
                if (!new File(file, "META-INF" + File.separator + "xdoclet.xml").exists()) continue;
                result.add(file);
                continue;
            }
            if (!jarFilter.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        modules = null;
    }
}

