/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navmenu.htmlnavmenu;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlCommandLink;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlPanelNavigationMenu;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class HtmlCommandNavigationItem
extends HtmlCommandLink {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlCommandNavigationItem == null ? (class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlCommandNavigationItem = HtmlCommandNavigationItem.class$("org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlCommandNavigationItem")) : class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlCommandNavigationItem));
    private Boolean _open = null;
    private Boolean _active = null;
    private String _activeOnViewIds = null;
    private String _externalLink = null;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlCommandNavigationItem";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    private static final String DEFAULT_RENDERER_TYPE = "javax.faces.Link";
    static /* synthetic */ Class class$org$apache$myfaces$custom$navmenu$htmlnavmenu$HtmlCommandNavigationItem;

    public boolean isImmediate() {
        return true;
    }

    public void setImmediate(Boolean immediate) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Immediate property of HtmlCommandNavigation cannot be set --> ignored.");
        }
    }

    public boolean isOpen() {
        if (this._open != null) {
            return this._open;
        }
        ValueBinding vb = this.getValueBinding("open");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null && v != false;
    }

    public Boolean getOpenDirectly() {
        return this._open;
    }

    public void setOpen(boolean open) {
        this._open = open ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isActive() {
        if (this._active != null) {
            return this._active;
        }
        ValueBinding vb = this.getValueBinding("active");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null && v != false;
    }

    public Boolean getActiveDirectly() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getActiveOnViewIds() {
        if (this._activeOnViewIds != null) {
            return this._activeOnViewIds;
        }
        ValueBinding vb = this.getValueBinding("activeOnViewIds");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setActiveOnViewIds(String activeOnViewIds) {
        this._activeOnViewIds = activeOnViewIds;
    }

    public String getExternalLink() {
        if (this._externalLink != null) {
            return this._externalLink;
        }
        ValueBinding vb = this.getValueBinding("externalLink");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setExternalLink(String externalLink) {
        this._externalLink = externalLink;
    }

    public boolean isRendered() {
        if (!super.isRendered()) {
            return false;
        }
        HtmlPanelNavigationMenu parentPanelNavMenu = this.getParentPanelNavigation();
        if (parentPanelNavMenu != null && parentPanelNavMenu.isRenderAll()) {
            return true;
        }
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof HtmlCommandNavigationItem && !((HtmlCommandNavigationItem)parent).isOpen()) {
                return false;
            }
            if (parent instanceof HtmlPanelNavigationMenu) break;
        }
        return true;
    }

    private HtmlPanelNavigationMenu getParentPanelNavigation() {
        UIComponent parent;
        UIComponent p;
        for (p = parent = this.getParent(); p != null && !(p instanceof HtmlPanelNavigationMenu); p = p.getParent()) {
        }
        if (!(p instanceof HtmlPanelNavigationMenu)) {
            log.error((Object)"HtmlCommandNavigation without parent HtmlPanelNavigation ?!");
            return null;
        }
        return (HtmlPanelNavigationMenu)p;
    }

    public void toggleOpen() {
        HtmlPanelNavigationMenu menu = this.getParentPanelNavigation();
        if (this.isOpen() && menu != null && !menu.isExpandAll()) {
            if (this.getChildCount() > 0) {
                this.setOpen(false);
            }
        } else {
            UIComponent p;
            UIComponent parent = this.getParent();
            HtmlCommandNavigationItem.closeAllChildren(parent.getChildren().iterator(), this, true);
            for (p = parent; p != null && !(p instanceof HtmlPanelNavigationMenu); p = p.getParent()) {
                if (!(p instanceof HtmlCommandNavigationItem)) continue;
                ((HtmlCommandNavigationItem)p).setOpen(true);
            }
            if (!(p instanceof HtmlPanelNavigationMenu)) {
                log.error((Object)"HtmlCommandNavigation without parent HtmlPanelNavigation ?!");
            } else if (!this.hasCommandNavigationChildren() || ((HtmlPanelNavigationMenu)p).isExpandAll()) {
                HtmlCommandNavigationItem.deactivateAllChildren(p.getChildren().iterator());
                this.setActive(true);
            } else {
                this.setOpen(true);
            }
        }
    }

    private boolean hasCommandNavigationChildren() {
        if (this.getChildCount() == 0) {
            return false;
        }
        List list = this.getChildren();
        int sizei = list.size();
        for (int i = 0; i < sizei; ++i) {
            if (!(list.get(i) instanceof HtmlCommandNavigationItem)) continue;
            return true;
        }
        return false;
    }

    private static void deactivateAllChildren(Iterator children) {
        while (children.hasNext()) {
            UIComponent ni = (UIComponent)children.next();
            if (!(ni instanceof HtmlCommandNavigationItem)) continue;
            ((HtmlCommandNavigationItem)ni).setActive(false);
            if (ni.getChildCount() <= 0) continue;
            HtmlCommandNavigationItem.deactivateAllChildren(ni.getChildren().iterator());
        }
    }

    private static void closeAllChildren(Iterator children, HtmlCommandNavigationItem current, boolean resetActive) {
        while (children.hasNext()) {
            UIComponent ni = (UIComponent)children.next();
            if (!(ni instanceof HtmlCommandNavigationItem)) continue;
            ((HtmlCommandNavigationItem)ni).setOpen(false);
            if (resetActive) {
                ((HtmlCommandNavigationItem)ni).setActive(false);
            }
            if (ni.getChildCount() <= 0) continue;
            HtmlCommandNavigationItem.closeAllChildren(ni.getChildren().iterator(), current, current != ni);
        }
    }

    public String[] getActiveOnVieIds() {
        String value = this.getActiveOnViewIds();
        if (value == null) {
            return new String[0];
        }
        return value.split(",");
    }

    private void openParents() {
        HtmlCommandNavigationItem comp = this;
        while ((comp = comp.getParent()) instanceof HtmlCommandNavigationItem) {
            HtmlCommandNavigationItem parent = comp;
            if (!parent.isOpen()) {
                parent.setOpen(true);
                continue;
            }
            return;
        }
    }

    public void deactivateAll() {
        UIComponent parent;
        for (parent = this.getParent(); !(parent instanceof HtmlPanelNavigationMenu) && parent != null; parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new IllegalStateException("no PanelNavigationMenu!");
        }
        HtmlPanelNavigationMenu root = (HtmlPanelNavigationMenu)parent;
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof HtmlCommandNavigationItem)) continue;
            HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)o;
            navItem.setActive(false);
            if (navItem.getChildCount() <= 0) continue;
            navItem.deactivateChildren();
        }
    }

    public void deactivateChildren() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof HtmlCommandNavigationItem)) continue;
            HtmlCommandNavigationItem current = (HtmlCommandNavigationItem)o;
            current.setActive(false);
            if (current.getChildCount() <= 0) continue;
            current.deactivateChildren();
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        ActionEvent actionEvent;
        if (event instanceof ActionEvent && (actionEvent = (ActionEvent)event).getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
            HtmlCommandNavigationItem navItem = (HtmlCommandNavigationItem)actionEvent.getComponent();
            navItem.toggleOpen();
            FacesContext.getCurrentInstance().renderResponse();
        }
        super.broadcast(event);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._open, this._active, this._activeOnViewIds, this._externalLink};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._open = (Boolean)values[1];
        this._active = (Boolean)values[2];
        this._activeOnViewIds = (String)values[3];
        this._externalLink = (String)values[4];
    }

    public HtmlCommandNavigationItem() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

