/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.digester.plugins.strategies;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.plugins.PluginException;
import com.sun.org.apache.commons.digester.plugins.RuleLoader;
import com.sun.org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import com.sun.org.apache.commons.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;

public class LoaderFromStream
extends RuleLoader {
    private byte[] input;
    private FromXmlRuleSet ruleSet;

    public LoaderFromStream(InputStream s) throws Exception {
        this.load(s);
    }

    private void load(InputStream s) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        while ((i = s.read(buf)) != -1) {
            baos.write(buf, 0, i);
        }
        this.input = baos.toByteArray();
    }

    public void addRules(Digester d, String path) throws PluginException {
        Log log = d.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("LoaderFromStream: loading rules for plugin at path [" + path + "]");
        }
        InputSource source = new InputSource(new ByteArrayInputStream(this.input));
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(source);
        ruleSet.addRuleInstances(d, path);
    }
}

