/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsse;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCServerMetaDataBuilder;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;

public class WSSecurityConfigFactory {
    final Logger log = Logger.getLogger(JAXRPCServerMetaDataBuilder.class);

    public static WSSecurityConfigFactory newInstance() {
        return new WSSecurityConfigFactory();
    }

    public WSSecurityConfiguration createConfiguration(UnifiedVirtualFile vfsRoot, String resourceName) throws IOException {
        URL configLocation = null;
        try {
            configLocation = new URL(resourceName);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (configLocation == null) {
            configLocation = this.getResource(vfsRoot, "WEB-INF/" + resourceName, false);
        }
        if (configLocation == null) {
            configLocation = this.getResource(vfsRoot, "META-INF/" + resourceName, false);
        }
        WSSecurityConfiguration config = null;
        if (configLocation != null) {
            this.log.debug((Object)("createConfiguration from: " + configLocation));
            config = WSSecurityOMFactory.newInstance().parse(configLocation);
            URL keystoreLocation = null;
            if (config.getKeyStoreFile() != null) {
                keystoreLocation = this.getResource(vfsRoot, config.getKeyStoreFile(), true);
                this.log.debug((Object)("Add keystore: " + keystoreLocation));
                config.setKeyStoreURL(keystoreLocation);
            }
            URL truststoreLocation = null;
            if (config.getTrustStoreFile() != null) {
                truststoreLocation = this.getResource(vfsRoot, config.getTrustStoreFile(), true);
                this.log.debug((Object)("Add truststore: " + truststoreLocation));
                config.setTrustStoreURL(truststoreLocation);
            }
        }
        return config;
    }

    private URL getResource(UnifiedVirtualFile vfsRoot, String resource, boolean failOnNotFound) {
        URL resourceURL;
        block2: {
            resourceURL = null;
            try {
                UnifiedVirtualFile child = vfsRoot.findChild(resource);
                resourceURL = child.toURL();
            }
            catch (IOException ex) {
                if (!failOnNotFound) break block2;
                throw new WSException("Cannot find required security resource: " + resource);
            }
        }
        return resourceURL;
    }
}

