/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.lang.reflect.Method;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.jaxrpc.ServletEndpointContextImpl;
import org.jboss.ws.core.jaxws.WebServiceContextInjector;
import org.jboss.ws.core.jaxws.WebServiceContextJSE;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.server.AbstractServiceEndpointInvoker;
import org.jboss.ws.core.server.EndpointContext;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;

public class ServiceEndpointInvokerJSE
extends AbstractServiceEndpointInvoker
implements ServiceEndpointInvoker {
    private Logger log = Logger.getLogger(ServiceEndpointInvokerJSE.class);

    public Class loadServiceEndpoint() throws ClassNotFoundException {
        ServerEndpointMetaData epMetaData = this.seInfo.getServerEndpointMetaData();
        ClassLoader cl = epMetaData.getClassLoader();
        String seiImplName = epMetaData.getServiceEndpointImplName();
        Class<?> seiImplClass = cl.loadClass(seiImplName);
        return seiImplClass;
    }

    public Object createServiceEndpointInstance(Object context, Class seiImplClass) throws IllegalAccessException, InstantiationException {
        Object seiImpl = seiImplClass.newInstance();
        if (seiImpl instanceof ServiceLifecycle && context != null) {
            try {
                ServiceLifecycle serviceLifecycle = (ServiceLifecycle)seiImpl;
                ServletEndpointContextImpl servletEndpointContext = new ServletEndpointContextImpl((EndpointContext)context);
                serviceLifecycle.init((Object)servletEndpointContext);
            }
            catch (ServiceException ex) {
                throw new WSException(ex);
            }
        }
        return seiImpl;
    }

    public void invokeServiceEndpointInstance(Object seiImpl, EndpointInvocation epInv) throws SOAPFaultException, Exception {
        this.log.debug((Object)("invokeServiceEndpoint: " + epInv.getJavaMethod().getName()));
        try {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext instanceof SOAPMessageContextJAXWS) {
                WebServiceContextJSE wsContext = new WebServiceContextJSE((SOAPMessageContextJAXWS)msgContext);
                new WebServiceContextInjector().injectContext(seiImpl, wsContext);
            }
            Class<?> implClass = seiImpl.getClass();
            Method seiMethod = epInv.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = epInv.getRequestPayload();
            Object retObj = implMethod.invoke(seiImpl, args);
            epInv.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.handleInvocationException(e);
        }
    }

    public void destroyServiceEndpointInstance(Object seiImpl) {
        if (seiImpl instanceof ServiceLifecycle) {
            ((ServiceLifecycle)seiImpl).destroy();
        }
    }
}

