/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.JAXRPCException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.EndpointContext;
import org.jboss.ws.core.server.ServiceEndpointManager;
import org.jboss.ws.core.server.ServiceEndpointManagerFactory;
import org.jboss.ws.core.utils.ObjectNameFactory;

public abstract class AbstractServiceEndpointServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AbstractServiceEndpointServlet.class);
    protected ObjectName sepId;
    protected ServiceEndpointManager epManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initServiceEndpointManager();
    }

    public void destroy() {
        super.destroy();
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.sepId == null) {
            String contextPath = req.getContextPath();
            this.initServiceEndpoint(contextPath);
        }
        super.service(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (req.getParameter("wsdl") != null || req.getParameter("WSDL") != null) {
            res.setContentType("text/xml");
            try {
                String resourcePath = req.getParameter("resource");
                URL requestURL = new URL(req.getRequestURL().toString());
                this.epManager.processWSDLRequest(this.sepId, (OutputStream)res.getOutputStream(), requestURL, resourcePath);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        } else {
            res.setStatus(405);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            ((Writer)out).write("HTTP GET not supported");
            ((Writer)out).flush();
            ((Writer)out).close();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        log.debug((Object)("doPost: " + req.getRequestURI()));
        try {
            EndpointContext context = new EndpointContext(this.getServletContext(), req, res);
            this.epManager.processRequest(this.sepId, (InputStream)req.getInputStream(), (OutputStream)res.getOutputStream(), context);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleException(Exception ex) throws ServletException {
        log.error((Object)"Error processing web service request", (Throwable)ex);
        if (ex instanceof JAXRPCException) {
            throw (JAXRPCException)ex;
        }
        throw new ServletException((Throwable)ex);
    }

    protected void initServiceEndpointManager() {
        ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
        this.epManager = factory.getServiceEndpointManager();
    }

    protected void initServiceEndpoint(String contextPath) {
        String servletName = this.getServletName();
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        for (ObjectName sepId : this.epManager.getServiceEndpoints()) {
            String context = sepId.getKeyProperty("context");
            String endpoint = sepId.getKeyProperty("endpoint");
            if (!servletName.equals(endpoint) || !contextPath.equals(context)) continue;
            this.sepId = sepId;
            break;
        }
        if (this.sepId == null) {
            ObjectName oname = ObjectNameFactory.create("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName);
            throw new WSException("Cannot obtain endpoint for: " + oname);
        }
    }
}

