/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.ws.core.jaxws.client.ServiceObjectFactory;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public class ServiceReferenceable
implements Referenceable {
    public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
    public static final String SERVICE_IMPL_CLASS = "SERVICE_CLASS_NAME";
    public static final String TARGET_CLASS_NAME = "TARGET_CLASS_NAME";
    private String serviceImplClass;
    private String targetClassName;
    private UnifiedServiceRefMetaData serviceRef;

    public ServiceReferenceable(String serviceImplClass, String targetClassName, UnifiedServiceRefMetaData serviceRef) {
        this.serviceImplClass = serviceImplClass;
        this.targetClassName = targetClassName;
        this.serviceRef = serviceRef;
    }

    public Reference getReference() throws NamingException {
        Reference myRef = new Reference(ServiceReferenceable.class.getName(), ServiceObjectFactory.class.getName(), null);
        myRef.add(new StringRefAddr(SERVICE_IMPL_CLASS, this.serviceImplClass));
        myRef.add(new StringRefAddr(TARGET_CLASS_NAME, this.targetClassName));
        myRef.add(new BinaryRefAddr(SERVICE_REF_META_DATA, this.marshall(this.serviceRef)));
        return myRef;
    }

    private byte[] marshall(Object obj) throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall object, cause: " + e.toString());
        }
        return baos.toByteArray();
    }
}

