/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.Interval;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class TimeSchedulerTest
extends TestCase {
    TimeScheduler timer = null;
    final int NUM_MSGS = 1000;
    long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    double PERCENTAGE_OFF = 0.3;
    HashMap msgs = new HashMap();

    public TimeSchedulerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.timer = new TimeScheduler();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.timer.stop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void test2Tasks() {
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.add(new MyTask(500L));
        int size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)size, (int)1);
        Util.sleep(1000L);
        size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)size, (int)0);
        Util.sleep(1500L);
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.add(new MyTask(500L));
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.add(new MyTask(500L));
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.add(new MyTask(500L));
        size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)size, (int)3);
        Util.sleep(1000L);
        size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)size, (int)0);
    }

    public void testRetransmits() {
        Entry entry;
        long i;
        int num_non_correct_entries = 0;
        System.out.println("-- adding 1000 messages:");
        for (i = 0L; i < 1000L; ++i) {
            entry = new Entry(i);
            this.msgs.put(new Long(i), entry);
            this.timer.add(entry);
        }
        System.out.println("-- done");
        System.out.println("-- waiting for 20 secs for all retransmits");
        Util.sleep(20000L);
        for (i = 0L; i < 1000L; ++i) {
            entry = (Entry)this.msgs.get(new Long(i));
            if (entry.isCorrect()) continue;
            ++num_non_correct_entries;
        }
        if (num_non_correct_entries > 0) {
            System.err.println("Number of incorrect retransmission timeouts: " + num_non_correct_entries);
        } else {
            for (i = 0L; i < 1000L; ++i) {
                entry = (Entry)this.msgs.get(new Long(i));
                if (entry == null) continue;
                System.out.println(i + ": " + entry);
            }
        }
        TimeSchedulerTest.assertTrue((num_non_correct_entries == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TimeSchedulerTest.class);
        return suite;
    }

    public static void main(String[] args) {
        String[] name = new String[]{TimeSchedulerTest.class.getName()};
        TestRunner.main((String[])name);
    }

    class Entry
    implements TimeScheduler.Task {
        long start_time = 0L;
        long first_xmit = 0L;
        long second_xmit = 0L;
        long third_xmit = 0L;
        long fourth_xmit = 0L;
        boolean cancelled = false;
        Interval interval;
        long seqno;

        Entry(long seqno) {
            this.interval = new Interval(TimeSchedulerTest.this.xmit_timeouts);
            this.seqno = 0L;
            this.seqno = seqno;
            this.start_time = System.currentTimeMillis();
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public long nextInterval() {
            return this.interval.next();
        }

        public void run() {
            if (this.first_xmit == 0L) {
                this.first_xmit = System.currentTimeMillis();
            } else if (this.second_xmit == 0L) {
                this.second_xmit = System.currentTimeMillis();
            } else if (this.third_xmit == 0L) {
                this.third_xmit = System.currentTimeMillis();
            } else if (this.fourth_xmit == 0L) {
                this.fourth_xmit = System.currentTimeMillis();
            }
        }

        boolean isCorrect() {
            long delta;
            boolean off = false;
            long expected = TimeSchedulerTest.this.xmit_timeouts[0];
            long t = this.first_xmit - this.start_time;
            long diff = Math.abs(expected - t);
            if (diff >= (delta = (long)((double)expected * TimeSchedulerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = TimeSchedulerTest.this.xmit_timeouts[1]) - (t = this.second_xmit - this.first_xmit))) >= (delta = (long)((double)expected * TimeSchedulerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = TimeSchedulerTest.this.xmit_timeouts[2]) - (t = this.third_xmit - this.second_xmit))) >= (delta = (long)((double)expected * TimeSchedulerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = TimeSchedulerTest.this.xmit_timeouts[3]) - (t = this.fourth_xmit - this.third_xmit))) >= (delta = (long)((double)expected * TimeSchedulerTest.this.PERCENTAGE_OFF))) {
                off = true;
            }
            if (off) {
                System.err.println("#" + this.seqno + ": " + this + ": (" + "entry is more than " + TimeSchedulerTest.this.PERCENTAGE_OFF + " percentage off ");
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first_xmit - this.start_time).append(", ").append(this.second_xmit - this.first_xmit).append(", ");
            sb.append(this.third_xmit - this.second_xmit).append(", ").append(this.fourth_xmit - this.third_xmit);
            return sb.toString();
        }
    }

    class StressTask
    implements TimeScheduler.Task {
        boolean cancelled = false;

        StressTask() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public long nextInterval() {
            return 50L;
        }

        public void run() {
            System.out.println("executed");
        }
    }

    class MyTask
    implements TimeScheduler.Task {
        boolean done = false;
        private long timeout = 0L;

        MyTask(long timeout) {
            this.timeout = timeout;
        }

        public boolean cancelled() {
            return this.done;
        }

        public long nextInterval() {
            return this.timeout;
        }

        public void run() {
            System.out.println(System.currentTimeMillis() + ": this is MyTask running - done");
            this.done = true;
        }
    }
}

