/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.Token;
import java.util.Iterator;
import java.util.Set;
import org.antlr.tool.Attribute;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.Rule;

public class NameSpaceChecker {
    protected Grammar grammar;

    public NameSpaceChecker(Grammar grammar) {
        this.grammar = grammar;
    }

    public void checkConflicts() {
        Object object;
        for (int i = 0; i < this.grammar.ruleIndexToRuleList.size(); ++i) {
            Object object2;
            object = (String)this.grammar.ruleIndexToRuleList.elementAt(i);
            if (object == null) continue;
            Rule rule = this.grammar.getRule((String)object);
            if (rule.labelNameSpace != null) {
                object2 = rule.labelNameSpace.values().iterator();
                while (object2.hasNext()) {
                    Grammar.LabelElementPair labelElementPair = (Grammar.LabelElementPair)object2.next();
                    this.checkForLabelConflict(rule, labelElementPair.label);
                }
            }
            if (rule.ruleScope != null) {
                object2 = rule.ruleScope.getAttributes();
                for (int j = 0; j < object2.size(); ++j) {
                    Attribute attribute = (Attribute)object2.get(j);
                    this.checkForRuleScopeAttributeConflict(rule, attribute);
                }
            }
            this.checkForRuleDefinitionProblems(rule);
            this.checkForRuleArgumentAndReturnValueConflicts(rule);
        }
        Iterator iterator = this.grammar.getGlobalScopes().values().iterator();
        while (iterator.hasNext()) {
            object = (AttributeScope)iterator.next();
            this.checkForGlobalScopeTokenConflict((AttributeScope)object);
        }
        this.lookForReferencesToUndefinedSymbols();
    }

    protected void checkForRuleArgumentAndReturnValueConflicts(Rule rule) {
        Set set;
        if (rule.returnScope != null && (set = rule.returnScope.intersection(rule.parameterScope)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ErrorManager.grammarError(126, this.grammar, rule.tree.getToken(), string, rule.name);
            }
        }
    }

    protected void checkForRuleDefinitionProblems(Rule rule) {
        String string = rule.name;
        Token token = rule.tree.getToken();
        int n = 0;
        if (this.grammar.type == 2 && Character.isUpperCase(string.charAt(0))) {
            n = 102;
        } else if (this.grammar.type == 1 && Character.isLowerCase(string.charAt(0))) {
            n = 103;
        } else if (this.grammar.getGlobalScope(string) != null) {
            n = 118;
        }
        if (n != 0) {
            ErrorManager.grammarError(n, this.grammar, token, string);
        }
    }

    protected void lookForReferencesToUndefinedSymbols() {
        String string;
        Token token;
        Iterator iterator = this.grammar.ruleRefs.iterator();
        while (iterator.hasNext()) {
            token = (Token)iterator.next();
            string = token.getText();
            if (this.grammar.getRule(string) != null || this.grammar.getTokenType(string) == -1) continue;
            ErrorManager.grammarError(106, this.grammar, token, string);
        }
        if (this.grammar.type == 4) {
            iterator = this.grammar.tokenIDRefs.iterator();
            while (iterator.hasNext()) {
                token = (Token)iterator.next();
                string = token.getText();
                if (this.grammar.lexerRules.contains(string) || this.grammar.getTokenType(string) == -1) continue;
                ErrorManager.grammarError(105, this.grammar, token, string);
            }
        }
    }

    protected void checkForGlobalScopeTokenConflict(AttributeScope attributeScope) {
        if (this.grammar.getTokenType(attributeScope.name) != -6) {
            ErrorManager.grammarError(118, this.grammar, null, attributeScope.name);
        }
    }

    public void checkForRuleScopeAttributeConflict(Rule rule, Attribute attribute) {
        int n = 0;
        String string = null;
        String string2 = attribute.name;
        if (rule.name.equals(string2)) {
            n = 123;
            string = rule.name;
        } else if (rule.returnScope != null && rule.returnScope.getAttribute(string2) != null || rule.parameterScope != null && rule.parameterScope.getAttribute(string2) != null) {
            n = 124;
            string = rule.name;
        }
        if (n != 0) {
            ErrorManager.grammarError(n, this.grammar, rule.tree.getToken(), string2, string);
        }
    }

    protected void checkForLabelConflict(Rule rule, Token token) {
        int n = 0;
        String string = null;
        if (this.grammar.getGlobalScope(token.getText()) != null) {
            n = 118;
        } else if (this.grammar.getRule(token.getText()) != null) {
            n = 119;
        } else if (this.grammar.getTokenType(token.getText()) != -6) {
            n = 120;
        } else if (rule.ruleScope != null && rule.ruleScope.getAttribute(token.getText()) != null) {
            n = 121;
            string = rule.name;
        } else if (rule.returnScope != null && rule.returnScope.getAttribute(token.getText()) != null || rule.parameterScope != null && rule.parameterScope.getAttribute(token.getText()) != null) {
            n = 122;
            string = rule.name;
        }
        if (n != 0) {
            ErrorManager.grammarError(n, this.grammar, token, token.getText(), string);
        }
    }

    public boolean checkForLabelTypeMismatch(Rule rule, Token token, int n) {
        Grammar.LabelElementPair labelElementPair = (Grammar.LabelElementPair)rule.labelNameSpace.get(token.getText());
        if (labelElementPair != null && labelElementPair.type != n) {
            String string = Grammar.LabelTypeToString[n] + "!=" + Grammar.LabelTypeToString[labelElementPair.type];
            ErrorManager.grammarError(125, this.grammar, token, token.getText(), string);
            return true;
        }
        return false;
    }
}

