/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Iterator;
import java.util.List;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.State;
import org.antlr.analysis.StateCluster;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class NFAFactory {
    NFA nfa = null;
    String currentRuleName = null;
    protected int stateCounter = 0;

    public NFAFactory(NFA nFA) {
        nFA.setFactory(this);
        this.nfa = nFA;
    }

    public NFAState newState() {
        int n;
        NFAState nFAState = new NFAState(this.nfa);
        nFAState.stateNumber = n = this.stateCounter++;
        this.nfa.addState(nFAState);
        nFAState.setEnclosingRuleName(this.currentRuleName);
        return nFAState;
    }

    public int getNumberOfStates() {
        return this.stateCounter;
    }

    public void optimizeAlternative(StateCluster stateCluster) {
        NFAState nFAState = stateCluster.left;
        while (nFAState != stateCluster.right) {
            if (nFAState.endOfBlockStateNumber != -1) {
                nFAState = this.nfa.getState(nFAState.endOfBlockStateNumber);
                continue;
            }
            Transition transition = nFAState.transition(0);
            if (transition instanceof RuleClosureTransition) {
                nFAState = ((RuleClosureTransition)transition).getFollowState();
                continue;
            }
            if (transition.label.isEpsilon() && nFAState.getNumberOfTransitions() == 1) {
                NFAState nFAState2 = (NFAState)transition.target;
                if (nFAState2.endOfBlockStateNumber == -1 && nFAState2.transition(0) != null) {
                    nFAState.setTransition0(nFAState2.transition(0));
                }
            }
            nFAState = (NFAState)transition.target;
        }
    }

    public StateCluster build_Atom(int n) {
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        this.transitionBetweenStates(nFAState, nFAState2, n);
        StateCluster stateCluster = new StateCluster(nFAState, nFAState2);
        return stateCluster;
    }

    public StateCluster build_Set(IntSet intSet) {
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        Transition transition = new Transition(new Label(intSet), (State)nFAState2);
        nFAState.addTransition(transition);
        StateCluster stateCluster = new StateCluster(nFAState, nFAState2);
        return stateCluster;
    }

    public StateCluster build_Range(int n, int n2) {
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        Transition transition = new Transition(new Label(IntervalSet.of(n, n2)), (State)nFAState2);
        nFAState.addTransition(transition);
        StateCluster stateCluster = new StateCluster(nFAState, nFAState2);
        return stateCluster;
    }

    public StateCluster build_CharLiteralAtom(String string) {
        int n = Grammar.getCharValueFromGrammarCharLiteral(string);
        return this.build_Atom(n);
    }

    public StateCluster build_CharRange(String string, String string2) {
        int n = Grammar.getCharValueFromGrammarCharLiteral(string);
        int n2 = Grammar.getCharValueFromGrammarCharLiteral(string2);
        return this.build_Range(n, n2);
    }

    public StateCluster build_StringLiteralAtom(String string) {
        if (this.nfa.grammar.type == 1) {
            StringBuffer stringBuffer = Grammar.getUnescapedStringFromGrammarStringLiteral(string);
            NFAState nFAState = this.newState();
            NFAState nFAState2 = null;
            NFAState nFAState3 = nFAState;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                NFAState nFAState4 = this.newState();
                this.transitionBetweenStates(nFAState3, nFAState4, c);
                nFAState3 = nFAState2 = nFAState4;
            }
            return new StateCluster(nFAState, nFAState2);
        }
        int n = this.nfa.grammar.getTokenType(string);
        return this.build_Atom(n);
    }

    public StateCluster build_RuleRef(int n, NFAState nFAState) {
        NFAState nFAState2 = this.newState();
        NFAState nFAState3 = this.newState();
        RuleClosureTransition ruleClosureTransition = new RuleClosureTransition(n, nFAState, nFAState3);
        nFAState2.addTransition(ruleClosureTransition);
        StateCluster stateCluster = new StateCluster(nFAState2, nFAState3);
        return stateCluster;
    }

    public StateCluster build_Epsilon() {
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        this.transitionBetweenStates(nFAState, nFAState2, -5);
        StateCluster stateCluster = new StateCluster(nFAState, nFAState2);
        return stateCluster;
    }

    public StateCluster build_SemanticPredicate(GrammarAST grammarAST) {
        ++this.nfa.grammar.numberOfSemanticPredicates;
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        Transition transition = new Transition(new Label(grammarAST), (State)nFAState2);
        nFAState.addTransition(transition);
        StateCluster stateCluster = new StateCluster(nFAState, nFAState2);
        return stateCluster;
    }

    public int build_EOFStates(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            String string = rule.name;
            NFAState nFAState = this.nfa.grammar.getRuleStopState(string);
            if (nFAState.transition(0) != null) continue;
            this.build_EOFState(nFAState);
            ++n;
        }
        return n;
    }

    private void build_EOFState(NFAState nFAState) {
        NFAState nFAState2 = this.newState();
        int n = -1;
        if (this.nfa.grammar.type == 1) {
            n = -2;
            nFAState2.setEOTTargetState(true);
        }
        Transition transition = new Transition(n, (State)nFAState2);
        nFAState.addTransition(transition);
    }

    public StateCluster build_AB(StateCluster stateCluster, StateCluster stateCluster2) {
        if (stateCluster == null) {
            return stateCluster2;
        }
        if (stateCluster2 == null) {
            return stateCluster;
        }
        this.transitionBetweenStates(stateCluster.right, stateCluster2.left, -5);
        StateCluster stateCluster3 = new StateCluster(stateCluster.left, stateCluster2.right);
        return stateCluster3;
    }

    public StateCluster build_AlternativeBlock(List list) {
        StateCluster stateCluster = null;
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            StateCluster stateCluster2 = (StateCluster)list.get(0);
            NFAState nFAState = this.newState();
            this.transitionBetweenStates(nFAState, stateCluster2.left, -5);
            return new StateCluster(nFAState, stateCluster2.right);
        }
        NFAState nFAState = null;
        NFAState nFAState2 = null;
        NFAState nFAState3 = this.newState();
        nFAState3.setDescription("end block");
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StateCluster stateCluster3 = (StateCluster)iterator.next();
            NFAState nFAState4 = this.newState();
            nFAState4.setDescription("alt " + n + " of ()");
            this.transitionBetweenStates(nFAState4, stateCluster3.left, -5);
            this.transitionBetweenStates(stateCluster3.right, nFAState3, -5);
            if (nFAState2 == null) {
                nFAState2 = nFAState4;
            } else {
                this.transitionBetweenStates(nFAState, nFAState4, -5);
            }
            nFAState = nFAState4;
            ++n;
        }
        stateCluster = new StateCluster(nFAState2, nFAState3);
        nFAState2.decisionStateType = 2;
        nFAState2.endOfBlockStateNumber = nFAState3.stateNumber;
        return stateCluster;
    }

    public StateCluster build_Aoptional(StateCluster stateCluster) {
        StateCluster stateCluster2 = null;
        int n = this.nfa.grammar.getNumberOfAltsForDecisionNFA(stateCluster.left);
        if (n == 1) {
            NFAState nFAState = this.newState();
            nFAState.setDescription("only alt of ()? block");
            NFAState nFAState2 = this.newState();
            nFAState2.setDescription("epsilon path of ()? block");
            NFAState nFAState3 = null;
            nFAState3 = this.newState();
            this.transitionBetweenStates(stateCluster.right, nFAState3, -5);
            nFAState3.setDescription("end ()? block");
            this.transitionBetweenStates(nFAState, stateCluster.left, -5);
            this.transitionBetweenStates(nFAState, nFAState2, -5);
            this.transitionBetweenStates(nFAState2, nFAState3, -5);
            nFAState.endOfBlockStateNumber = nFAState3.stateNumber;
            stateCluster2 = new StateCluster(nFAState, nFAState3);
        } else {
            NFAState nFAState = this.nfa.grammar.getNFAStateForAltOfDecision(stateCluster.left, n);
            NFAState nFAState4 = this.newState();
            nFAState4.setDescription("epsilon path of ()? block");
            this.transitionBetweenStates(nFAState, nFAState4, -5);
            this.transitionBetweenStates(nFAState4, stateCluster.right, -5);
            stateCluster.left.endOfBlockStateNumber = stateCluster.right.stateNumber;
            stateCluster2 = stateCluster;
        }
        stateCluster.left.decisionStateType = 3;
        return stateCluster2;
    }

    public StateCluster build_Aplus(StateCluster stateCluster) {
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        this.transitionBetweenStates(stateCluster.right, nFAState2, -5);
        this.transitionBetweenStates(stateCluster.right, stateCluster.left, -5);
        this.transitionBetweenStates(nFAState, stateCluster.left, -5);
        stateCluster.right.decisionStateType = 1;
        stateCluster.left.decisionStateType = 2;
        stateCluster.left.endOfBlockStateNumber = stateCluster.right.stateNumber;
        StateCluster stateCluster2 = new StateCluster(nFAState, nFAState2);
        return stateCluster2;
    }

    public StateCluster build_Astar(StateCluster stateCluster) {
        NFAState nFAState = this.newState();
        nFAState.setDescription("enter loop path of ()* block");
        NFAState nFAState2 = this.newState();
        nFAState2.setDescription("epsilon path of ()* block");
        NFAState nFAState3 = this.newState();
        stateCluster.right.setDescription("()* loopback");
        this.transitionBetweenStates(nFAState, stateCluster.left, -5);
        this.transitionBetweenStates(nFAState, nFAState2, -5);
        this.transitionBetweenStates(nFAState2, nFAState3, -5);
        this.transitionBetweenStates(stateCluster.right, nFAState3, -5);
        this.transitionBetweenStates(stateCluster.right, stateCluster.left, -5);
        nFAState.decisionStateType = 4;
        stateCluster.left.decisionStateType = 2;
        stateCluster.right.decisionStateType = 1;
        stateCluster.left.endOfBlockStateNumber = stateCluster.right.stateNumber;
        nFAState.endOfBlockStateNumber = nFAState3.stateNumber;
        StateCluster stateCluster2 = new StateCluster(nFAState, nFAState3);
        return stateCluster2;
    }

    public StateCluster build_Wildcard() {
        NFAState nFAState = this.newState();
        NFAState nFAState2 = this.newState();
        Label label = new Label(this.nfa.grammar.getTokenTypes());
        Transition transition = new Transition(label, (State)nFAState2);
        nFAState.addTransition(transition);
        StateCluster stateCluster = new StateCluster(nFAState, nFAState2);
        return stateCluster;
    }

    protected IntSet getCollapsedBlockAsSet(State state) {
        Label label;
        State state2;
        State state3 = state;
        if (state3 != null && state3.transition(0) != null && (state2 = state3.transition((int)0).target) != null && state2.transition(0) != null && (label = state2.transition((int)0).label).isSet()) {
            return label.getSet();
        }
        return null;
    }

    private void transitionBetweenStates(NFAState nFAState, NFAState nFAState2, int n) {
        Transition transition = new Transition(n, (State)nFAState2);
        nFAState.addTransition(transition);
    }
}

