/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.security;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSSecurityException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.jms.server.SecurityStore;
import org.jboss.jms.server.security.CheckType;
import org.jboss.jms.server.security.SecurityActions;
import org.jboss.jms.server.security.SecurityMetadata;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.w3c.dom.Element;

public class SecurityMetadataStore
implements SecurityStore {
    private static final Logger log = Logger.getLogger(SecurityMetadataStore.class);
    public static final String SUCKER_USER = "JBM.SUCKER";
    public static final String DEFAULT_SUCKER_USER_PASSWORD = "CHANGE ME!!";
    private boolean trace = log.isTraceEnabled();
    private Map queueSecurityConf = new HashMap();
    private Map topicSecurityConf = new HashMap();
    private AuthenticationManager authenticationManager;
    private RealmMapping realmMapping;
    private Element defaultSecurityConfig;
    private String securityDomain;
    private String suckerPassword;

    public SecurityMetadata getSecurityMetadata(boolean isQueue, String destName) {
        SecurityMetadata m = (SecurityMetadata)(isQueue ? this.queueSecurityConf.get(destName) : this.topicSecurityConf.get(destName));
        if (m == null) {
            if (this.defaultSecurityConfig != null) {
                log.debug((Object)("No SecurityMetadadata was available for " + destName + ", using default security config"));
                try {
                    m = new SecurityMetadata(this.defaultSecurityConfig);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to apply default security for destName, using guest " + destName), (Throwable)e);
                    m = new SecurityMetadata();
                }
            } else {
                log.warn((Object)("No SecurityMetadadata was available for " + destName + ", adding guest"));
                m = new SecurityMetadata();
            }
        }
        return m;
    }

    public void setSecurityConfig(boolean isQueue, String destName, Element conf) throws Exception {
        if (this.trace) {
            log.trace((Object)("adding security configuration for " + (isQueue ? "queue " : "topic ") + destName));
        }
        if (conf == null) {
            this.clearSecurityConfig(isQueue, destName);
        } else {
            SecurityMetadata m = new SecurityMetadata(conf);
            if (isQueue) {
                this.queueSecurityConf.put(destName, m);
            } else {
                this.topicSecurityConf.put(destName, m);
            }
        }
    }

    public void clearSecurityConfig(boolean isQueue, String name) throws Exception {
        if (this.trace) {
            log.trace((Object)("clearing security configuration for " + (isQueue ? "queue " : "topic ") + name));
        }
        if (isQueue) {
            this.queueSecurityConf.remove(name);
        } else {
            this.topicSecurityConf.remove(name);
        }
    }

    public Subject authenticate(String user, String password) throws JMSSecurityException {
        if (this.trace) {
            log.trace((Object)("authenticating user " + user));
        }
        SimplePrincipal principal = new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        Subject subject = new Subject();
        boolean authenticated = false;
        if (SUCKER_USER.equals(user)) {
            if (this.trace) {
                log.trace((Object)"Authenticating sucker user");
            }
            this.checkDefaultSuckerPassword(password);
            authenticated = this.suckerPassword.equals(password);
        } else {
            authenticated = this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject);
        }
        if (authenticated) {
            SecurityActions.pushSubjectContext((Principal)principal, passwordChars, subject);
            return subject;
        }
        throw new JMSSecurityException("User " + user + " is NOT authenticated");
    }

    public boolean authorize(String user, Set rolePrincipals, CheckType checkType) {
        if (this.trace) {
            log.trace((Object)("authorizing user " + user + " for role(s) " + rolePrincipals.toString()));
        }
        if (SUCKER_USER.equals(user)) {
            return checkType.equals(CheckType.READ) || checkType.equals(CheckType.WRITE);
        }
        SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
        boolean hasRole = this.realmMapping.doesUserHaveRole((Principal)principal, rolePrincipals);
        if (this.trace) {
            log.trace((Object)("user " + user + (hasRole ? " is " : " is NOT ") + "authorized"));
        }
        return hasRole;
    }

    public void setSuckerPassword(String password) {
        this.checkDefaultSuckerPassword(password);
        this.suckerPassword = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws NamingException {
        block7: {
            if (this.trace) {
                log.trace((Object)"initializing SecurityMetadataStore");
            }
            InitialContext ic = new InitialContext();
            try {
                Object mgr = ic.lookup(this.securityDomain);
                log.debug((Object)("JaasSecurityManager is " + mgr));
                this.authenticationManager = (AuthenticationManager)mgr;
                this.realmMapping = (RealmMapping)mgr;
                log.trace((Object)"SecurityMetadataStore initialized");
            }
            catch (NamingException e) {
                log.warn((Object)("Failed to lookup securityDomain " + this.securityDomain), (Throwable)e);
                if (!this.securityDomain.startsWith("java:/jaas/")) {
                    this.authenticationManager = (SubjectSecurityManager)ic.lookup("java:/jaas/" + this.securityDomain);
                    break block7;
                }
                throw e;
            }
            finally {
                ic.close();
            }
        }
    }

    public void stop() throws Exception {
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public Element getDefaultSecurityConfig() {
        return this.defaultSecurityConfig;
    }

    public void setDefaultSecurityConfig(Element conf) throws Exception {
        new SecurityMetadata(conf);
        this.defaultSecurityConfig = conf;
    }

    private void checkDefaultSuckerPassword(String password) {
        if (DEFAULT_SUCKER_USER_PASSWORD.equals(password)) {
            log.warn((Object)"WARNING! POTENTIAL SECURITY RISK. It has been detected that the MessageSucker component which sucks messages from one node to another has not had its password changed from the installation default. Please see the JBoss Messaging user guide for instructions on how to do this.");
        }
    }
}

