/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.UnsupportedEncodingException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public abstract class FileUploadTestCase
extends TestCase {
    protected static final String CONTENT_TYPE = "multipart/form-data; boundary=---1234";

    protected List parseUpload(byte[] bytes) throws FileUploadException {
        return this.parseUpload(bytes, CONTENT_TYPE);
    }

    protected List parseUpload(byte[] bytes, String contentType) throws FileUploadException {
        ServletFileUpload upload = new ServletFileUpload(new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(bytes, contentType);
        List fileItems = upload.parseRequest(request);
        return fileItems;
    }

    protected List parseUpload(String content) throws UnsupportedEncodingException, FileUploadException {
        byte[] bytes = content.getBytes("US-ASCII");
        return this.parseUpload(bytes, CONTENT_TYPE);
    }
}

