/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.test.C3P0BenchmarkApp;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;

public final class C3P0BenchmarkApp {
    static final String EMPTY_TABLE_CREATE = "CREATE TABLE emptyyukyuk (a varchar(8), b varchar(8))";
    static final String EMPTY_TABLE_SELECT = "SELECT * FROM emptyyukyuk";
    static final String EMPTY_TABLE_DROP = "DROP TABLE emptyyukyuk";
    static final String EMPTY_TABLE_CONDITIONAL_SELECT = "SELECT * FROM emptyyukyuk where a = ?";
    static final String N_ENTRY_TABLE_CREATE = "CREATE TABLE n_entryyukyuk (a INTEGER)";
    static final String N_ENTRY_TABLE_INSERT = "INSERT INTO n_entryyukyuk VALUES ( ? )";
    static final String N_ENTRY_TABLE_SELECT = "SELECT * FROM n_entryyukyuk";
    static final String N_ENTRY_TABLE_DROP = "DROP TABLE n_entryyukyuk";
    static final int NUM_ITERATIONS = 2000;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp;

    /*
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        block14: {
            DataSource dataSource = null;
            DataSource dataSource2 = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (stringArray.length == 3) {
                string = stringArray[0];
                string2 = stringArray[1];
                string3 = stringArray[2];
            } else if (stringArray.length == 1) {
                string = stringArray[0];
                string2 = null;
                string3 = null;
            } else {
                C3P0BenchmarkApp.usage();
            }
            if (!string.startsWith("jdbc:")) {
                C3P0BenchmarkApp.usage();
            }
            dataSource = DataSources.unpooledDataSource(string, string2, string3);
            dataSource2 = DataSources.pooledDataSource(dataSource);
            C3P0BenchmarkApp.create(dataSource2);
            System.out.println("Please wait. Tests can be very slow.");
            ArrayList<Test> arrayList = new ArrayList<Test>();
            arrayList.add(new ConnectionAcquisitionTest());
            arrayList.add(new StatementCreateTest());
            arrayList.add(new StatementEmptyTableSelectTest());
            arrayList.add(new PreparedStatementEmptyTableSelectTest());
            arrayList.add(new PreparedStatementAcquireTest());
            arrayList.add(new ResultSetReadTest());
            arrayList.add(new FiveThreadPSQueryTestTest());
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                ((Test)arrayList.get(n)).perform(dataSource, dataSource2, 2000);
                ++n;
            }
            Object var10_10 = null;
            try {
                C3P0BenchmarkApp.drop(dataSource2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block14;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var10_11 = null;
                    try {
                        C3P0BenchmarkApp.drop(dataSource2);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    C3P0BenchmarkApp.drop(dataSource2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private static void usage() {
        System.err.println("java -Djdbc.drivers=<comma_sep_list_of_drivers> " + (class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp == null ? (class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp = C3P0BenchmarkApp.class$("com.mchange.v2.c3p0.test.C3P0BenchmarkApp")) : class$com$mchange$v2$c3p0$test$C3P0BenchmarkApp).getName() + " <jdbc_url> [<username> <password>]");
        System.exit(-1);
    }

    static void create(DataSource dataSource) throws SQLException {
        System.err.println("Creating test schema.");
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(EMPTY_TABLE_CREATE);
            preparedStatement2 = connection.prepareStatement(N_ENTRY_TABLE_CREATE);
            preparedStatement3 = connection.prepareStatement(N_ENTRY_TABLE_INSERT);
            preparedStatement.executeUpdate();
            preparedStatement2.executeUpdate();
            int n = 0;
            while (n < 2000) {
                preparedStatement3.setInt(1, n);
                preparedStatement3.executeUpdate();
                System.err.print('.');
                ++n;
            }
            System.err.println();
            System.err.println("Test schema created.");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            StatementUtils.attemptClose(preparedStatement);
            StatementUtils.attemptClose(preparedStatement2);
            StatementUtils.attemptClose(preparedStatement3);
            ConnectionUtils.attemptClose(connection);
            throw throwable;
        }
        StatementUtils.attemptClose(preparedStatement);
        StatementUtils.attemptClose(preparedStatement2);
        StatementUtils.attemptClose(preparedStatement3);
        ConnectionUtils.attemptClose(connection);
    }

    static void drop(DataSource dataSource) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(EMPTY_TABLE_DROP);
            preparedStatement2 = connection.prepareStatement(N_ENTRY_TABLE_DROP);
            preparedStatement.executeUpdate();
            preparedStatement2.executeUpdate();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StatementUtils.attemptClose(preparedStatement);
            StatementUtils.attemptClose(preparedStatement2);
            ConnectionUtils.attemptClose(connection);
            throw throwable;
        }
        StatementUtils.attemptClose(preparedStatement);
        StatementUtils.attemptClose(preparedStatement2);
        ConnectionUtils.attemptClose(connection);
        System.err.println("Test schema dropped.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class FiveThreadPSQueryTestTest
    extends Test {
        FiveThreadPSQueryTestTest() {
            super("Five threads getting a connection, executing a query, " + System.getProperty("line.separator") + "and retrieving results concurrently via a prepared statement.");
        }

        protected long test(DataSource dataSource, int n) throws Exception {
            long l = System.currentTimeMillis();
            Thread[] threadArray = new Thread[5];
            int n2 = 0;
            while (n2 < 5) {
                class QueryThread
                extends Thread {
                    private final /* synthetic */ int val$n;
                    private final /* synthetic */ DataSource val$ds;
                    private final /* synthetic */ FiveThreadPSQueryTestTest this$0;

                    QueryThread(FiveThreadPSQueryTestTest fiveThreadPSQueryTestTest, int n, DataSource dataSource, int n2) {
                        super("QueryThread-" + n2);
                        this.this$0 = fiveThreadPSQueryTestTest;
                        this.val$n = n;
                        this.val$ds = dataSource;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        Connection connection = null;
                        PreparedStatement preparedStatement = null;
                        ResultSet resultSet = null;
                        int n = 0;
                        while (true) {
                            block7: {
                                Object var7_6;
                                if (n >= this.val$n / 5) {
                                    return;
                                }
                                try {
                                    try {
                                        connection = this.val$ds.getConnection();
                                        preparedStatement = connection.prepareStatement("SELECT * FROM emptyyukyuk where a = ?");
                                        preparedStatement.setString(1, "boo");
                                        resultSet = preparedStatement.executeQuery();
                                        while (resultSet.next()) {
                                            System.err.println("Huh?? Empty table has values?");
                                        }
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        var7_6 = null;
                                        ResultSetUtils.attemptClose(resultSet);
                                        StatementUtils.attemptClose(preparedStatement);
                                        ConnectionUtils.attemptClose(connection);
                                        break block7;
                                    }
                                    var7_6 = null;
                                }
                                catch (Throwable throwable) {
                                    var7_6 = null;
                                    ResultSetUtils.attemptClose(resultSet);
                                    StatementUtils.attemptClose(preparedStatement);
                                    ConnectionUtils.attemptClose(connection);
                                    throw throwable;
                                }
                                ResultSetUtils.attemptClose(resultSet);
                                StatementUtils.attemptClose(preparedStatement);
                                ConnectionUtils.attemptClose(connection);
                            }
                            ++n;
                        }
                    }
                }
                threadArray[n2] = new QueryThread(this, n, dataSource, n2);
                threadArray[n2].start();
                ++n2;
            }
            int n3 = 0;
            while (n3 < 5) {
                threadArray[n3].join();
                ++n3;
            }
            return System.currentTimeMillis() - l;
        }
    }

    static class ResultSetReadTest
    extends Test {
        ResultSetReadTest() {
            super("Reading one row / one entry from a result set");
        }

        protected long test(DataSource dataSource, int n) throws SQLException {
            long l;
            if (n > 10000) {
                throw new IllegalArgumentException("10K max.");
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = dataSource.getConnection();
                preparedStatement = connection.prepareStatement(C3P0BenchmarkApp.N_ENTRY_TABLE_SELECT);
                resultSet = preparedStatement.executeQuery();
                long l2 = System.currentTimeMillis();
                int n2 = 0;
                while (n2 < n) {
                    if (!resultSet.next()) {
                        System.err.println("huh?");
                    }
                    resultSet.getInt(1);
                    ++n2;
                }
                long l3 = System.currentTimeMillis();
                l = l3 - l2;
                Object var14_10 = null;
            }
            catch (Throwable throwable) {
                Object var14_11 = null;
                ResultSetUtils.attemptClose(resultSet);
                StatementUtils.attemptClose(preparedStatement);
                ConnectionUtils.attemptClose(connection);
                throw throwable;
            }
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(preparedStatement);
            ConnectionUtils.attemptClose(connection);
            return l;
        }
    }

    static class PreparedStatementEmptyTableSelectTest
    extends Test {
        PreparedStatementEmptyTableSelectTest() {
            super("Empty Table PreparedStatement Select (on a single PreparedStatement)");
        }

        protected long test(DataSource dataSource, int n) throws SQLException {
            long l;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = dataSource.getConnection();
                preparedStatement = connection.prepareStatement(C3P0BenchmarkApp.EMPTY_TABLE_SELECT);
                l = this.test(preparedStatement, n);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                StatementUtils.attemptClose(preparedStatement);
                ConnectionUtils.attemptClose(connection);
                throw throwable;
            }
            StatementUtils.attemptClose(preparedStatement);
            ConnectionUtils.attemptClose(connection);
            return l;
        }

        long test(PreparedStatement preparedStatement, int n) throws SQLException {
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                preparedStatement.executeQuery().close();
                ++n2;
            }
            long l2 = System.currentTimeMillis();
            return l2 - l;
        }
    }

    static class PreparedStatementAcquireTest
    extends Test {
        PreparedStatementAcquireTest() {
            super("Acquire and Cleanup a PreparedStatement (same statement, many times)");
        }

        protected long test(DataSource dataSource, int n) throws SQLException {
            long l;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                connection = dataSource.getConnection();
                long l2 = System.currentTimeMillis();
                int n2 = 0;
                while (n2 < n) {
                    Object var11_7;
                    try {
                        preparedStatement = connection.prepareStatement(C3P0BenchmarkApp.EMPTY_TABLE_CONDITIONAL_SELECT);
                        var11_7 = null;
                    }
                    catch (Throwable throwable) {
                        var11_7 = null;
                        StatementUtils.attemptClose(preparedStatement);
                        throw throwable;
                    }
                    StatementUtils.attemptClose(preparedStatement);
                    ++n2;
                }
                long l3 = System.currentTimeMillis();
                l = l3 - l2;
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                ConnectionUtils.attemptClose(connection);
                throw throwable;
            }
            ConnectionUtils.attemptClose(connection);
            return l;
        }
    }

    static class StatementEmptyTableSelectTest
    extends Test {
        StatementEmptyTableSelectTest() {
            super("Empty Table Statement Select (on a single Statement)");
        }

        protected long test(DataSource dataSource, int n) throws SQLException {
            long l;
            Connection connection = null;
            Statement statement = null;
            try {
                connection = dataSource.getConnection();
                statement = connection.createStatement();
                l = this.test(statement, n);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                StatementUtils.attemptClose(statement);
                ConnectionUtils.attemptClose(connection);
                throw throwable;
            }
            StatementUtils.attemptClose(statement);
            ConnectionUtils.attemptClose(connection);
            return l;
        }

        long test(Statement statement, int n) throws SQLException {
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                statement.executeQuery(C3P0BenchmarkApp.EMPTY_TABLE_SELECT).close();
                ++n2;
            }
            long l2 = System.currentTimeMillis();
            return l2 - l;
        }
    }

    static class StatementCreateTest
    extends Test {
        StatementCreateTest() {
            super("Statement Creation and Cleanup");
        }

        protected long test(DataSource dataSource, int n) throws SQLException {
            long l;
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                l = this.test(connection, n);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                ConnectionUtils.attemptClose(connection);
                throw throwable;
            }
            ConnectionUtils.attemptClose(connection);
            return l;
        }

        long test(Connection connection, int n) throws SQLException {
            Statement statement = null;
            long l = System.currentTimeMillis();
            try {
                int n2 = 0;
                while (n2 < n) {
                    statement = connection.createStatement();
                    ++n2;
                }
                Object var10_6 = null;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                StatementUtils.attemptClose(statement);
                throw throwable;
            }
            StatementUtils.attemptClose(statement);
            long l2 = System.currentTimeMillis();
            return l2 - l;
        }
    }

    static class ConnectionAcquisitionTest
    extends Test {
        ConnectionAcquisitionTest() {
            super("Connection Acquisition and Cleanup");
        }

        protected long test(DataSource dataSource, int n) throws Exception {
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                Object var10_6;
                Connection connection = null;
                try {
                    connection = dataSource.getConnection();
                    var10_6 = null;
                }
                catch (Throwable throwable) {
                    var10_6 = null;
                    ConnectionUtils.attemptClose(connection);
                    throw throwable;
                }
                ConnectionUtils.attemptClose(connection);
                ++n2;
            }
            long l2 = System.currentTimeMillis();
            return l2 - l;
        }
    }

    static abstract class Test {
        String name;

        Test(String string) {
            this.name = string;
        }

        public void perform(DataSource dataSource, DataSource dataSource2, int n) throws Exception {
            double d = (double)this.test(dataSource, n) / (double)n;
            double d2 = (double)this.test(dataSource2, n) / (double)n;
            System.out.println(this.name + " [ " + n + " iterations ]:");
            System.out.println("\tunpooled: " + d + " msecs");
            System.out.println("\t  pooled: " + d2 + " msecs");
            System.out.println("\tspeed-up factor: " + d / d2 + " times");
            System.out.println("\tspeed-up absolute: " + (d - d2) + " msecs");
            System.out.println();
        }

        protected abstract long test(DataSource var1, int var2) throws Exception;
    }
}

