/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    ResourcePool rp;
    ConnectionEventListener cl = new ConnectionEventListenerImpl();
    ConnectionTester connectionTester;
    GooGooStatementCache scache;

    C3P0PooledConnectionPool(final ConnectionPoolDataSource connectionPoolDataSource, final DbAuth dbAuth, int n, int n2, int n3, int n4, final boolean bl, GooGooStatementCache gooGooStatementCache, final ConnectionTester connectionTester, ResourcePoolFactory resourcePoolFactory) throws SQLException {
        try {
            this.scache = gooGooStatementCache;
            this.connectionTester = connectionTester;
            ResourcePool.Manager manager = new ResourcePool.Manager(){

                public Object acquireResource() throws Exception {
                    PooledConnection pooledConnection;
                    PooledConnection pooledConnection2 = pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? connectionPoolDataSource.getPooledConnection() : connectionPoolDataSource.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
                    if (C3P0PooledConnectionPool.this.scache != null) {
                        if (pooledConnection instanceof C3P0PooledConnection) {
                            ((C3P0PooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                        } else {
                            System.err.print("Warning! StatementPooling not ");
                            System.err.print("implemented for external (non-c3p0) ");
                            System.err.println("ConnectionPoolDataSources.");
                        }
                    }
                    pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    return pooledConnection;
                }

                public void refurbishResource(Object object) throws Exception {
                    if (bl) {
                        int n;
                        PooledConnection pooledConnection = (PooledConnection)object;
                        try {
                            n = connectionTester.activeCheckConnection(pooledConnection.getConnection());
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                            n = -1;
                        }
                        switch (n) {
                            case 0: {
                                break;
                            }
                            case -8: {
                                C3P0PooledConnectionPool.this.rp.resetPool();
                            }
                            case -1: {
                                throw new SQLException("Connection is invalid");
                            }
                            default: {
                                throw new Error("Bad Connection Tester (" + connectionTester + ") " + "returned invalid status (" + n + ").");
                            }
                        }
                    }
                }

                public void destroyResource(Object object) throws Exception {
                    ((PooledConnection)object).close();
                }
            };
            ResourcePoolFactory resourcePoolFactory2 = resourcePoolFactory;
            synchronized (resourcePoolFactory2) {
                resourcePoolFactory.setMin(n);
                resourcePoolFactory.setMax(n2);
                resourcePoolFactory.setIncrement(n3);
                resourcePoolFactory.setResourceMaxAge(n4 * 1000);
                resourcePoolFactory.setAgeIsAbsolute(false);
                this.rp = resourcePoolFactory.createPool(manager);
            }
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource();
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void checkinPooledConnection(PooledConnection pooledConnection) throws SQLException {
        try {
            this.rp.checkinResource(pooledConnection);
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public void close() throws SQLException {
        try {
            this.rp.close();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(connectionEvent.getSource());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            try {
                int n;
                PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
                SQLException sQLException = connectionEvent.getSQLException();
                try {
                    n = C3P0PooledConnectionPool.this.connectionTester.statusOnException(pooledConnection.getConnection(), sQLException);
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                    n = -1;
                }
                switch (n) {
                    case 0: {
                        break;
                    }
                    case -8: {
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pooledConnection);
                        break;
                    }
                    default: {
                        throw new Error("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + n + ").");
                    }
                }
            }
            catch (ResourcePoolException resourcePoolException) {
                System.err.println("Uh oh... our resource pool is probably broken!");
                resourcePoolException.printStackTrace();
            }
        }
    }
}

